<?php

use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Http\Controllers\Dashboard\ContactController;
use App\Http\Controllers\Dashboard\GroupController;
use App\Http\Controllers\Dashboard\TagController;
use App\Http\Controllers\Dashboard\SourceController;
use App\Http\Controllers\Dashboard\UnsubscribedController;
use App\Http\Controllers\Dashboard\WhatsappController;
use App\Http\Controllers\Dashboard\WaScheduledController;
use App\Http\Controllers\Dashboard\WaCampaignController;
use App\Http\Controllers\Dashboard\WaGroupController;
use App\Http\Controllers\Dashboard\WaQueueController;
use App\Http\Controllers\Dashboard\Sms\SentController as SmsSentController;
use App\Http\Controllers\Dashboard\Sms\ReceivedController as SmsReceivedController;
use App\Http\Controllers\Dashboard\Sms\ScheduledController as SmsScheduledController;
use App\Http\Controllers\Dashboard\Sms\QueueController as SmsQueueController;
use App\Http\Controllers\Dashboard\Sms\CampaignController as SmsCampaignController;
use App\Http\Controllers\Dashboard\Sms\TransactionController as UserTransactionController;
use App\Http\Controllers\Dashboard\Tools\ActionController;
use App\Http\Controllers\Dashboard\Tools\FlowController;
use App\Http\Controllers\Dashboard\Tools\KeyController;
use App\Http\Controllers\Dashboard\Tools\WebhookController;
use App\Http\Controllers\Dashboard\Tools\TemplateController;
use App\Http\Controllers\Dashboard\Tools\TemplateCategoryController;
use App\Http\Controllers\Dashboard\Tools\StaffController;
use App\Http\Controllers\Dashboard\Tools\LoggerController;
use App\Http\Controllers\Dashboard\Ai\AiKeyController;
use App\Http\Controllers\Dashboard\Ai\AiPluginController;
use App\Http\Controllers\Dashboard\Hosts\DeviceController;
use App\Http\Controllers\Dashboard\Hosts\WaAccountController;
use App\Http\Controllers\Dashboard\Hosts\UssdController;
use App\Http\Controllers\Dashboard\Reports\ReportController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\SubscriptionController;
use App\Http\Controllers\Admin\TransactionController;
use App\Http\Controllers\Admin\GatewayController;
use App\Http\Controllers\Admin\PluginController;
use App\Http\Controllers\Admin\LanguageController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\VoucherController;
use App\Http\Controllers\Admin\PayoutController;
use App\Http\Controllers\Admin\ShortenerController;
use App\Http\Controllers\Admin\WaServerController;
use App\Http\Controllers\Admin\SettingController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Public routes
Route::get('/', function () {
    return redirect()->route('login');
});

// Authentication Routes
Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login']);
    Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
    Route::post('/register', [AuthController::class, 'register']);
    Route::get('/forgot-password', [AuthController::class, 'showForgotPassword'])->name('password.request');
    Route::post('/forgot-password', [AuthController::class, 'forgotPassword'])->name('password.email');
});

Route::post('/logout', [AuthController::class, 'logout'])->name('logout')->middleware('auth');

// Dashboard Routes (Authenticated Users)
Route::middleware(['auth'])->group(function () {
    // Main Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/profile', [DashboardController::class, 'profile'])->name('profile');
    Route::put('/profile', [DashboardController::class, 'updateProfile'])->name('profile.update');
    Route::put('/profile/password', [DashboardController::class, 'updatePassword'])->name('profile.password');

    // Contacts
    Route::resource('contacts', ContactController::class);
    Route::post('/contacts/import', [ContactController::class, 'import'])->name('contacts.import');
    
    // Groups
    Route::resource('groups', GroupController::class)->except(['create', 'show', 'edit']);
    
    // Tags
    Route::resource('tags', TagController::class)->except(['create', 'show', 'edit']);
    
    // Sources
    Route::resource('sources', SourceController::class)->except(['create', 'show', 'edit']);
    
    // Unsubscribed
    Route::resource('unsubscribed', UnsubscribedController::class)->except(['create', 'show', 'edit', 'update']);

    // WhatsApp
    Route::prefix('whatsapp')->name('whatsapp.')->group(function () {
        Route::get('/accounts', [WhatsappController::class, 'accounts'])->name('accounts');
        Route::get('/accounts/create', [WhatsappController::class, 'createAccount'])->name('accounts.create');
        Route::get('/accounts/{account}/status', [WhatsappController::class, 'checkStatus'])->name('accounts.status');
        Route::delete('/accounts/{account}', [WhatsappController::class, 'deleteAccount'])->name('accounts.delete');
        
        Route::get('/messenger', [WhatsappController::class, 'messenger'])->name('messenger');
        Route::get('/conversation', [WhatsappController::class, 'getConversation'])->name('conversation');
        Route::post('/send', [WhatsappController::class, 'sendMessage'])->name('send');
        
        Route::get('/sent', [WhatsappController::class, 'sent'])->name('sent');
        Route::get('/received', [WhatsappController::class, 'received'])->name('received');
        
        // Queue
        Route::get('/queue', [WaQueueController::class, 'index'])->name('queue');
        Route::post('/queue/clear', [WaQueueController::class, 'clear'])->name('queue.clear');
        Route::delete('/queue/{message}', [WaQueueController::class, 'destroy'])->name('queue.destroy');
        
        // Scheduled
        Route::get('/scheduled', [WaScheduledController::class, 'index'])->name('scheduled');
        Route::post('/scheduled', [WaScheduledController::class, 'store'])->name('scheduled.store');
        Route::put('/scheduled/{scheduled}', [WaScheduledController::class, 'update'])->name('scheduled.update');
        Route::delete('/scheduled/{scheduled}', [WaScheduledController::class, 'destroy'])->name('scheduled.destroy');
        
        // Campaigns
        Route::get('/campaigns', [WaCampaignController::class, 'index'])->name('campaigns');
        Route::post('/campaigns', [WaCampaignController::class, 'store'])->name('campaigns.store');
        Route::post('/campaigns/{campaign}/start', [WaCampaignController::class, 'start'])->name('campaigns.start');
        Route::post('/campaigns/{campaign}/stop', [WaCampaignController::class, 'stop'])->name('campaigns.stop');
        Route::delete('/campaigns/{campaign}', [WaCampaignController::class, 'destroy'])->name('campaigns.destroy');
        
        // Groups
        Route::get('/groups', [WaGroupController::class, 'index'])->name('groups');
        Route::post('/groups/sync', [WaGroupController::class, 'sync'])->name('groups.sync');
        Route::get('/groups/{group}/members', [WaGroupController::class, 'members'])->name('groups.members');
    });

    // SMS
    Route::prefix('sms')->name('sms.')->group(function () {
        Route::get('/sent', [SmsSentController::class, 'index'])->name('sent');
        Route::delete('/sent/{sent}', [SmsSentController::class, 'destroy'])->name('sent.destroy');
        
        Route::get('/received', [SmsReceivedController::class, 'index'])->name('received');
        Route::delete('/received/{received}', [SmsReceivedController::class, 'destroy'])->name('received.destroy');
        
        Route::get('/queue', [SmsQueueController::class, 'index'])->name('queue');
        Route::post('/queue/clear', [SmsQueueController::class, 'clear'])->name('queue.clear');
        
        Route::get('/scheduled', [SmsScheduledController::class, 'index'])->name('scheduled');
        Route::post('/scheduled', [SmsScheduledController::class, 'store'])->name('scheduled.store');
        Route::put('/scheduled/{scheduled}', [SmsScheduledController::class, 'update'])->name('scheduled.update');
        Route::delete('/scheduled/{scheduled}', [SmsScheduledController::class, 'destroy'])->name('scheduled.destroy');
        
        Route::get('/campaigns', [SmsCampaignController::class, 'index'])->name('campaigns');
        Route::post('/campaigns', [SmsCampaignController::class, 'store'])->name('campaigns.store');
        Route::delete('/campaigns/{campaign}', [SmsCampaignController::class, 'destroy'])->name('campaigns.destroy');
        
        Route::get('/transactions', [UserTransactionController::class, 'index'])->name('transactions');
    });

    // Tools
    Route::prefix('tools')->name('tools.')->group(function () {
        Route::resource('actions', ActionController::class)->except(['create', 'show', 'edit']);
        Route::resource('flows', FlowController::class)->except(['create', 'show', 'edit']);
        Route::resource('keys', KeyController::class)->except(['create', 'show', 'edit']);
        Route::post('/keys/{key}/regenerate', [KeyController::class, 'regenerate'])->name('keys.regenerate');
        Route::resource('webhooks', WebhookController::class)->except(['create', 'show', 'edit']);
        Route::resource('templates', TemplateController::class)->except(['create', 'show', 'edit']);
        Route::resource('template-categories', TemplateCategoryController::class)->except(['create', 'show', 'edit']);
        Route::resource('staff', StaffController::class)->except(['create', 'show', 'edit']);
        Route::get('/logger', [LoggerController::class, 'index'])->name('logger');
        Route::post('/logger/clear', [LoggerController::class, 'clear'])->name('logger.clear');
    });

    // AI
    Route::prefix('ai')->name('ai.')->group(function () {
        Route::resource('keys', AiKeyController::class)->except(['create', 'show', 'edit']);
        Route::resource('plugins', AiPluginController::class)->except(['create', 'show', 'edit']);
    });

    // Hosts
    Route::prefix('hosts')->name('hosts.')->group(function () {
        Route::get('/android', [DeviceController::class, 'index'])->name('android');
        Route::post('/android', [DeviceController::class, 'store'])->name('android.store');
        Route::put('/android/{device}', [DeviceController::class, 'update'])->name('android.update');
        Route::delete('/android/{device}', [DeviceController::class, 'destroy'])->name('android.destroy');
        
        Route::get('/whatsapp', [WaAccountController::class, 'index'])->name('whatsapp');
        Route::get('/whatsapp/create', [WaAccountController::class, 'create'])->name('whatsapp.create');
        Route::get('/whatsapp/{account}/status', [WaAccountController::class, 'checkStatus'])->name('whatsapp.status');
        Route::put('/whatsapp/{account}', [WaAccountController::class, 'update'])->name('whatsapp.update');
        Route::delete('/whatsapp/{account}', [WaAccountController::class, 'destroy'])->name('whatsapp.destroy');
        
        Route::get('/ussd', [UssdController::class, 'index'])->name('ussd');
        Route::post('/ussd', [UssdController::class, 'store'])->name('ussd.store');
        Route::delete('/ussd/{ussd}', [UssdController::class, 'destroy'])->name('ussd.destroy');
    });

    // Reports
    Route::prefix('reports')->name('reports.')->group(function () {
        Route::get('/', [ReportController::class, 'index'])->name('index');
        Route::get('/contacts', [ReportController::class, 'contacts'])->name('contacts');
        Route::get('/messages', [ReportController::class, 'messages'])->name('messages');
        Route::get('/staff', [ReportController::class, 'staff'])->name('staff');
    });
});

// Admin Routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', [AdminController::class, 'dashboard'])->name('dashboard');
    
    // Users Management
    Route::get('/users', [AdminController::class, 'users'])->name('users.index');
    Route::get('/users/create', [AdminController::class, 'createUser'])->name('users.create');
    Route::post('/users', [AdminController::class, 'storeUser'])->name('users.store');
    Route::get('/users/{user}/edit', [AdminController::class, 'editUser'])->name('users.edit');
    Route::put('/users/{user}', [AdminController::class, 'updateUser'])->name('users.update');
    Route::post('/users/{user}/toggle', [AdminController::class, 'toggleUserStatus'])->name('users.toggle');
    Route::post('/users/{user}/credits', [AdminController::class, 'addCredits'])->name('users.credits');
    Route::delete('/users/{user}', [AdminController::class, 'deleteUser'])->name('users.destroy');
    
    // Packages
    Route::resource('packages', PackageController::class)->except(['create', 'show', 'edit']);
    
    // Roles
    Route::resource('roles', RoleController::class)->except(['create', 'show', 'edit']);
    
    // Subscriptions
    Route::get('/subscriptions', [SubscriptionController::class, 'index'])->name('subscriptions.index');
    Route::post('/subscriptions', [SubscriptionController::class, 'store'])->name('subscriptions.store');
    Route::put('/subscriptions/{subscription}', [SubscriptionController::class, 'update'])->name('subscriptions.update');
    Route::post('/subscriptions/{subscription}/extend', [SubscriptionController::class, 'extend'])->name('subscriptions.extend');
    Route::delete('/subscriptions/{subscription}', [SubscriptionController::class, 'destroy'])->name('subscriptions.destroy');
    
    // Transactions
    Route::get('/transactions', [TransactionController::class, 'index'])->name('transactions.index');
    
    // Gateways
    Route::get('/gateways', [GatewayController::class, 'index'])->name('gateways.index');
    Route::post('/gateways', [GatewayController::class, 'store'])->name('gateways.store');
    Route::put('/gateways/{gateway}', [GatewayController::class, 'update'])->name('gateways.update');
    Route::post('/gateways/{gateway}/rates', [GatewayController::class, 'rates'])->name('gateways.rates');
    Route::post('/gateways/{gateway}/toggle', [GatewayController::class, 'toggle'])->name('gateways.toggle');
    Route::delete('/gateways/{gateway}', [GatewayController::class, 'destroy'])->name('gateways.destroy');
    
    // Plugins
    Route::get('/plugins', [PluginController::class, 'index'])->name('plugins.index');
    Route::post('/plugins', [PluginController::class, 'store'])->name('plugins.store');
    Route::put('/plugins/{plugin}', [PluginController::class, 'update'])->name('plugins.update');
    Route::post('/plugins/{plugin}/toggle', [PluginController::class, 'toggle'])->name('plugins.toggle');
    Route::delete('/plugins/{plugin}', [PluginController::class, 'destroy'])->name('plugins.destroy');
    
    // Languages
    Route::get('/languages', [LanguageController::class, 'index'])->name('languages.index');
    Route::post('/languages', [LanguageController::class, 'store'])->name('languages.store');
    Route::put('/languages/{language}', [LanguageController::class, 'update'])->name('languages.update');
    Route::post('/languages/{language}/translate', [LanguageController::class, 'translate'])->name('languages.translate');
    Route::delete('/languages/{language}', [LanguageController::class, 'destroy'])->name('languages.destroy');
    
    // Pages
    Route::resource('pages', PageController::class)->except(['create', 'show', 'edit']);
    
    // Vouchers
    Route::get('/vouchers', [VoucherController::class, 'index'])->name('vouchers.index');
    Route::post('/vouchers', [VoucherController::class, 'store'])->name('vouchers.store');
    Route::put('/vouchers/{voucher}', [VoucherController::class, 'update'])->name('vouchers.update');
    Route::delete('/vouchers/{voucher}', [VoucherController::class, 'destroy'])->name('vouchers.destroy');
    
    // Payouts
    Route::get('/payouts', [PayoutController::class, 'index'])->name('payouts.index');
    Route::post('/payouts/{payout}/approve', [PayoutController::class, 'approve'])->name('payouts.approve');
    Route::post('/payouts/{payout}/reject', [PayoutController::class, 'reject'])->name('payouts.reject');
    
    // Shorteners
    Route::get('/shorteners', [ShortenerController::class, 'index'])->name('shorteners.index');
    Route::post('/shorteners', [ShortenerController::class, 'store'])->name('shorteners.store');
    Route::put('/shorteners/{shortener}', [ShortenerController::class, 'update'])->name('shorteners.update');
    Route::post('/shorteners/{shortener}/toggle', [ShortenerController::class, 'toggle'])->name('shorteners.toggle');
    Route::delete('/shorteners/{shortener}', [ShortenerController::class, 'destroy'])->name('shorteners.destroy');
    
    // WhatsApp Servers
    Route::get('/waservers', [WaServerController::class, 'index'])->name('waservers.index');
    Route::post('/waservers', [WaServerController::class, 'store'])->name('waservers.store');
    Route::put('/waservers/{server}', [WaServerController::class, 'update'])->name('waservers.update');
    Route::post('/waservers/{server}/test', [WaServerController::class, 'test'])->name('waservers.test');
    Route::delete('/waservers/{server}', [WaServerController::class, 'destroy'])->name('waservers.destroy');
    
    // Marketing
    Route::get('/marketing', [\App\Http\Controllers\Admin\MarketingController::class, 'index'])->name('marketing.index');
    Route::post('/marketing/email', [\App\Http\Controllers\Admin\MarketingController::class, 'email'])->name('marketing.email');
    Route::post('/marketing/notify', [\App\Http\Controllers\Admin\MarketingController::class, 'notify'])->name('marketing.notify');
    Route::post('/marketing/mailer', [\App\Http\Controllers\Admin\MarketingController::class, 'mailer'])->name('marketing.mailer');
    
    // Settings
    Route::get('/settings', [SettingController::class, 'index'])->name('settings.index');
    Route::post('/settings/general', [SettingController::class, 'general'])->name('settings.general');
    Route::post('/settings/system', [SettingController::class, 'system'])->name('settings.system');
    Route::post('/settings/payment', [SettingController::class, 'payment'])->name('settings.payment');
    Route::post('/settings/theme', [SettingController::class, 'theme'])->name('settings.theme');
});

// Misc Public Routes
Route::get('/packages', [\App\Http\Controllers\MiscController::class, 'packages'])->name('misc.packages');
Route::get('/rates/gateways', [\App\Http\Controllers\MiscController::class, 'gatewayRates'])->name('misc.rates.gateways');
Route::get('/rates/partners', [\App\Http\Controllers\MiscController::class, 'partnerRates'])->name('misc.rates.partners');
Route::get('/page/{id}/{slug}', [\App\Http\Controllers\PageController::class, 'show'])->name('page.show');

// Unsubscribe
Route::get('/unsubscribe', [\App\Http\Controllers\UnsubscribeController::class, 'show'])->name('unsubscribe');
Route::post('/unsubscribe', [\App\Http\Controllers\UnsubscribeController::class, 'confirm'])->name('unsubscribe.confirm');

// Documentation Routes
Route::middleware(['auth'])->prefix('docs')->name('dashboard.docs.')->group(function () {
    Route::get('/', [\App\Http\Controllers\DocsController::class, 'index'])->name('index');
    Route::get('/webhooks', [\App\Http\Controllers\DocsController::class, 'webhooks'])->name('webhooks');
    Route::get('/actions', [\App\Http\Controllers\DocsController::class, 'actions'])->name('actions');
    Route::get('/android', [\App\Http\Controllers\DocsController::class, 'android'])->name('android');
    Route::get('/partners', [\App\Http\Controllers\DocsController::class, 'partners'])->name('partners');
    Route::get('/admin', [\App\Http\Controllers\DocsController::class, 'admin'])->name('admin');
});

// Messenger Routes
Route::middleware(['auth'])->prefix('messenger')->name('messenger.')->group(function () {
    Route::get('/', [\App\Http\Controllers\MessengerController::class, 'index'])->name('index');
    Route::get('/chat/{phone}', [\App\Http\Controllers\MessengerController::class, 'chat'])->name('chat');
    Route::post('/send', [\App\Http\Controllers\MessengerController::class, 'send'])->name('send');
});

// Flow Builder Routes
Route::middleware(['auth'])->prefix('flows')->name('flows.')->group(function () {
    Route::get('/builder', [\App\Http\Controllers\Dashboard\FlowBuilderController::class, 'create'])->name('builder');
    Route::get('/builder/{id}', [\App\Http\Controllers\Dashboard\FlowBuilderController::class, 'edit'])->name('builder.edit');
    Route::post('/save', [\App\Http\Controllers\Dashboard\FlowBuilderController::class, 'store'])->name('save');
    Route::put('/save/{id}', [\App\Http\Controllers\Dashboard\FlowBuilderController::class, 'update'])->name('update');
});

/*
|--------------------------------------------------------------------------
| WhatsApp Bridge Webhook Routes
|--------------------------------------------------------------------------
| هذه الـ endpoints يجب أن تبقى متطابقة تماماً مع النظام القديم
| ليعمل WhatsApp Bridge بدون أي تعديل
| Bridge يرسل البيانات إلى هذه الـ URLs
*/
Route::prefix('whatsapp')->name('webhook.whatsapp.')->group(function () {
    // تحديث عنوان الخادم
    Route::get('/server', [\App\Http\Controllers\WhatsappWebhookController::class, 'server'])->name('server');
    
    // جلب الرسائل المعلقة للإرسال - يستدعيها Bridge
    Route::get('/messages', [\App\Http\Controllers\WhatsappWebhookController::class, 'messages'])->name('messages');
    
    // نجاح ربط الحساب - يستدعيها Bridge بعد مسح QR
    Route::get('/link/success', [\App\Http\Controllers\WhatsappWebhookController::class, 'linkSuccess'])->name('link.success');
    
    // استقبال رسالة واردة - يستدعيها Bridge عند استقبال رسالة
    Route::post('/received', [\App\Http\Controllers\WhatsappWebhookController::class, 'received'])->name('received');
    
    // تحديث حالة الرسالة المرسلة
    Route::post('/status', [\App\Http\Controllers\WhatsappWebhookController::class, 'status'])->name('status');
    
    // تحديث (قراءة/حذف/تعديل)
    Route::post('/update', [\App\Http\Controllers\WhatsappWebhookController::class, 'update'])->name('update');
});
