<?php

use App\Http\Controllers\Api\ApiController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
| يجب أن تكون هذه الـ endpoints متطابقة مع النظام القديم
| لضمان عمل جميع التطبيقات والخدمات المتكاملة
*/

/*
|--------------------------------------------------------------------------
| Public API v1
|--------------------------------------------------------------------------
*/
Route::prefix('v1')->group(function () {
    // Account
    Route::get('/account', [ApiController::class, 'getAccount']);
    
    // WhatsApp Messages
    Route::post('/whatsapp/send', [ApiController::class, 'sendWhatsapp']);
    Route::post('/whatsapp/send/bulk', [ApiController::class, 'sendBulkWhatsapp']);
    Route::post('/whatsapp/send/media', [ApiController::class, 'sendWhatsappMedia']);
    Route::get('/whatsapp/sent', [ApiController::class, 'getWhatsappSent']);
    Route::get('/whatsapp/received', [ApiController::class, 'getWhatsappReceived']);
    
    // WhatsApp Accounts
    Route::get('/whatsapp/accounts', [ApiController::class, 'getWhatsappAccounts']);
    Route::get('/whatsapp/accounts/{unique}/status', [ApiController::class, 'getWhatsappAccountStatus']);
    
    // WhatsApp Groups
    Route::get('/whatsapp/groups', [ApiController::class, 'getWhatsappGroups']);
    Route::get('/whatsapp/groups/{id}/members', [ApiController::class, 'getWhatsappGroupMembers']);
    
    // Validate Number
    Route::get('/whatsapp/validate/{phone}', [ApiController::class, 'validateWhatsappNumber']);
    
    // SMS
    Route::post('/sms/send', [ApiController::class, 'sendSms']);
    Route::post('/sms/send/bulk', [ApiController::class, 'sendBulkSms']);
    Route::get('/sms/sent', [ApiController::class, 'getSmsSent']);
    Route::get('/sms/received', [ApiController::class, 'getSmsReceived']);
    
    // Contacts
    Route::get('/contacts', [ApiController::class, 'getContacts']);
    Route::post('/contacts', [ApiController::class, 'addContact']);
    Route::put('/contacts/{id}', [ApiController::class, 'updateContact']);
    Route::delete('/contacts/{id}', [ApiController::class, 'deleteContact']);
    
    // Groups
    Route::get('/groups', [ApiController::class, 'getGroups']);
    Route::post('/groups', [ApiController::class, 'addGroup']);
    Route::delete('/groups/{id}', [ApiController::class, 'deleteGroup']);
    
    // USSD
    Route::post('/ussd/send', [ApiController::class, 'sendUssd']);
    Route::get('/ussd', [ApiController::class, 'getUssd']);
    
    // Android Devices
    Route::get('/devices/android', [ApiController::class, 'getDevices']);
    Route::post('/devices/android/sim', [ApiController::class, 'getDeviceSims']);
    
    // Webhooks
    Route::post('/webhook/test', [ApiController::class, 'testWebhook']);
});

/*
|--------------------------------------------------------------------------
| WhatsApp Bridge Webhook API
|--------------------------------------------------------------------------
| هذه الـ endpoints تستخدمها Bridge لإرسال البيانات
*/
Route::post('/webhook/whatsapp', [\App\Http\Controllers\WhatsappWebhookController::class, 'received']);
Route::post('/webhook/whatsapp/status', [\App\Http\Controllers\WhatsappWebhookController::class, 'status']);
Route::post('/webhook/whatsapp/update', [\App\Http\Controllers\WhatsappWebhookController::class, 'update']);

/*
|--------------------------------------------------------------------------
| Android Device API
|--------------------------------------------------------------------------
| يستخدمها تطبيق Android
*/
Route::prefix('remote')->group(function () {
    Route::get('/messages', [\App\Http\Controllers\Api\AndroidController::class, 'messages']);
    Route::post('/status', [\App\Http\Controllers\Api\AndroidController::class, 'status']);
    Route::post('/received', [\App\Http\Controllers\Api\AndroidController::class, 'received']);
    Route::post('/ussd', [\App\Http\Controllers\Api\AndroidController::class, 'ussd']);
});
