<!-- WhatsApp Quick Message Modal -->
<div class="modal fade" id="whatsappQuickModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('quick_message') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('dashboard.whatsapp.send') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('account') }}</label>
                        <select name="account" class="form-control" required>
                            @foreach($waAccounts ?? [] as $account)
                            <option value="{{ $account->unique }}">{{ $account->name ?? $account->phone }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('recipient') }}</label>
                        <input type="text" name="phone" class="form-control" placeholder="+1234567890" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('message') }}</label>
                        <textarea name="message" class="form-control" rows="4" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-success">
                        <i class="bi bi-send"></i> {{ __('send') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
