<!-- WhatsApp Bulk Message Modal -->
<div class="modal fade" id="whatsappBulkModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('bulk_message') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('dashboard.whatsapp.bulk') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('account') }}</label>
                            <select name="account" class="form-control" required>
                                @foreach($waAccounts ?? [] as $account)
                                <option value="{{ $account->unique }}">{{ $account->name ?? $account->phone }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('contact_group') }}</label>
                            <select name="group" class="form-control">
                                <option value="">{{ __('select_group') }}</option>
                                @foreach($groups ?? [] as $group)
                                <option value="{{ $group->id }}">{{ $group->name }} ({{ $group->contacts_count }})</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('recipients') }}</label>
                            <textarea name="recipients" class="form-control" rows="3" placeholder="{{ __('one_number_per_line') }}"></textarea>
                            <small class="text-muted">{{ __('or_select_group_above') }}</small>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('message') }}</label>
                            <textarea name="message" class="form-control" rows="4" required></textarea>
                            <small class="text-muted">{{ __('spintax_supported') }}: {Hi|Hello|Hey}</small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('delay_between_messages') }}</label>
                            <input type="number" name="delay" class="form-control" value="5" min="1" max="60">
                            <small class="text-muted">{{ __('seconds') }}</small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('priority') }}</label>
                            <select name="priority" class="form-control">
                                <option value="1">{{ __('high') }}</option>
                                <option value="2" selected>{{ __('normal') }}</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-success">
                        <i class="bi bi-send"></i> {{ __('send_bulk') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
