<!-- SMS Bulk Message Modal -->
<div class="modal fade" id="smsBulkModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('bulk_sms') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('dashboard.sms.bulk') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('device') }}</label>
                            <select name="device" class="form-control" required>
                                @foreach($devices ?? [] as $device)
                                <option value="{{ $device->id }}">{{ $device->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('contact_group') }}</label>
                            <select name="group" class="form-control">
                                <option value="">{{ __('select_group') }}</option>
                                @foreach($groups ?? [] as $group)
                                <option value="{{ $group->id }}">{{ $group->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('recipients') }}</label>
                            <textarea name="recipients" class="form-control" rows="3" placeholder="{{ __('one_number_per_line') }}"></textarea>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('message') }}</label>
                            <textarea name="message" class="form-control" rows="4" required></textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('gateway') }}</label>
                            <select name="gateway" class="form-control">
                                <option value="device">{{ __('android_device') }}</option>
                                @foreach($gateways ?? [] as $gateway)
                                <option value="{{ $gateway->id }}">{{ $gateway->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-send"></i> {{ __('send_bulk') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
