<!-- Add Autoreply Modal -->
<div class="modal fade" id="addAutoreplyModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('add_autoreply') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('dashboard.actions.store') }}" method="POST">
                @csrf
                <input type="hidden" name="type" value="autoreply">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('name') }}</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('source') }}</label>
                            <select name="source" class="form-control" required>
                                <option value="all">{{ __('all_sources') }}</option>
                                <option value="sms">SMS</option>
                                <option value="whatsapp">WhatsApp</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('trigger_type') }}</label>
                            <select name="trigger_type" class="form-control" required>
                                <option value="contains">{{ __('contains') }}</option>
                                <option value="exact">{{ __('exact_match') }}</option>
                                <option value="starts">{{ __('starts_with') }}</option>
                                <option value="regex">{{ __('regex') }}</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('trigger_value') }}</label>
                            <input type="text" name="trigger_value" class="form-control" required>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('response') }}</label>
                            <textarea name="response" class="form-control" rows="4" required></textarea>
                            <small class="text-muted">{{ __('variables_hint') }}: {name}, {phone}, {message}</small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check">
                                <input type="checkbox" name="status" class="form-check-input" value="1" checked>
                                <label class="form-check-label">{{ __('active') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
