@extends('layouts.app')

@section('title', __('unsubscribe'))

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6 text-center">
            @if($success ?? false)
            <div class="mb-4">
                <i class="bi bi-check-circle text-success" style="font-size: 80px;"></i>
            </div>
            <h2>{{ __('unsubscribed_successfully') }}</h2>
            <p class="text-muted">{{ __('unsubscribe_success_message') }}</p>
            @else
            <div class="card">
                <div class="card-body">
                    <h3 class="mb-4">{{ __('unsubscribe_title') }}</h3>
                    <p class="text-muted">{{ __('unsubscribe_confirm_message') }}</p>
                    <form action="{{ route('unsubscribe.confirm') }}" method="POST">
                        @csrf
                        <input type="hidden" name="phone" value="{{ $phone ?? '' }}">
                        <input type="hidden" name="token" value="{{ $token ?? '' }}">
                        <button type="submit" class="btn btn-danger">
                            <i class="bi bi-x-circle"></i> {{ __('confirm_unsubscribe') }}
                        </button>
                    </form>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
