@extends('mail.default')

@section('content')
<h2>{{ __('subscription_expiring') }}</h2>
<p>{{ __('dear') }} {{ $user->name }},</p>
<p>{{ __('subscription_expiring_message', ['days' => $daysRemaining]) }}</p>
<table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
    <tr>
        <td style="padding: 10px; border: 1px solid #ddd;"><strong>{{ __('package') }}</strong></td>
        <td style="padding: 10px; border: 1px solid #ddd;">{{ $subscription->package->name ?? 'N/A' }}</td>
    </tr>
    <tr>
        <td style="padding: 10px; border: 1px solid #ddd;"><strong>{{ __('expires_on') }}</strong></td>
        <td style="padding: 10px; border: 1px solid #ddd;">{{ $subscription->end_date }}</td>
    </tr>
</table>
<p>{{ __('renew_now_message') }}</p>
<p>
    <a href="{{ route('dashboard.misc.packages') }}" class="btn">{{ __('renew_subscription') }}</a>
</p>
@endsection
