<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" @if(app()->getLocale() == 'ar') dir="rtl" @endif>

<head>
    <link rel="dns-prefetch" href="//fonts.googleapis.com">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/favicon.png') }}">

    <title>{{ $title ?? 'Flow Builder' }} &middot; {{ config('app.name') }}</title>

    <!-- Line Awesome Icons -->
    <link rel="stylesheet" href="https://maxst.icons8.com/vue-static/lanern/css/line-awesome.min.css">
    
    <!-- Drawflow CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/jerosoler/Drawflow/dist/drawflow.min.css">
    
    <style>
        :root {
            --primary-color: #25D366;
            --secondary-color: #128C7E;
            --sidebar-width: 280px;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Cairo', 'Segoe UI', sans-serif;
            background: #1a1a2e;
            color: #fff;
            overflow: hidden;
        }
        
        .wrapper {
            display: flex;
            height: 100vh;
        }
        
        .col {
            width: var(--sidebar-width);
            background: #16213e;
            padding: 20px;
            overflow-y: auto;
            border-left: 1px solid #0f3460;
        }
        
        [dir="ltr"] .col {
            border-left: none;
            border-right: 1px solid #0f3460;
        }
        
        .drag-drawflow {
            background: #0f3460;
            padding: 12px 15px;
            margin-bottom: 10px;
            border-radius: 8px;
            cursor: move;
            display: flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s;
            border: 1px solid transparent;
        }
        
        .drag-drawflow:hover {
            background: #1a1a4e;
            border-color: var(--primary-color);
        }
        
        .drag-drawflow i {
            font-size: 20px;
            color: var(--primary-color);
        }
        
        .drag-drawflow span {
            font-size: 14px;
        }
        
        .col-right {
            flex: 1;
            position: relative;
        }
        
        #drawflow {
            width: 100%;
            height: 100%;
            background: #1a1a2e;
            background-image: 
                linear-gradient(rgba(255,255,255,0.05) 1px, transparent 1px),
                linear-gradient(90deg, rgba(255,255,255,0.05) 1px, transparent 1px);
            background-size: 20px 20px;
        }
        
        .btn-export, .btn-clear {
            position: absolute;
            top: 20px;
            padding: 10px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: bold;
            z-index: 100;
            transition: all 0.3s;
        }
        
        .btn-export {
            right: 20px;
            background: var(--primary-color);
            color: #fff;
        }
        
        [dir="rtl"] .btn-export {
            right: auto;
            left: 120px;
        }
        
        .btn-export:hover {
            background: var(--secondary-color);
        }
        
        .btn-clear {
            right: 100px;
            background: #e74c3c;
            color: #fff;
        }
        
        [dir="rtl"] .btn-clear {
            right: auto;
            left: 20px;
        }
        
        .btn-clear:hover {
            background: #c0392b;
        }
        
        .bar-zoom {
            position: absolute;
            bottom: 20px;
            right: 20px;
            display: flex;
            gap: 5px;
            z-index: 100;
        }
        
        [dir="rtl"] .bar-zoom {
            right: auto;
            left: 20px;
        }
        
        .bar-zoom i {
            width: 40px;
            height: 40px;
            background: #0f3460;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            font-size: 18px;
            transition: background 0.3s;
        }
        
        .bar-zoom i:hover {
            background: var(--primary-color);
        }
        
        /* Drawflow Customization */
        .drawflow .drawflow-node {
            background: #16213e;
            border: 2px solid #0f3460;
            border-radius: 10px;
            min-width: 200px;
        }
        
        .drawflow .drawflow-node.selected {
            border-color: var(--primary-color);
        }
        
        .drawflow .drawflow-node .title-box {
            background: var(--primary-color);
            padding: 10px 15px;
            border-radius: 8px 8px 0 0;
            font-weight: bold;
        }
        
        .drawflow .drawflow-node .box {
            padding: 15px;
        }
        
        .drawflow .connection .main-path {
            stroke: var(--primary-color);
            stroke-width: 3px;
        }
        
        .drawflow .drawflow-node input,
        .drawflow .drawflow-node select,
        .drawflow .drawflow-node textarea {
            background: #1a1a2e;
            border: 1px solid #0f3460;
            color: #fff;
            padding: 8px;
            border-radius: 5px;
            width: 100%;
            margin-top: 5px;
        }
        
        .drawflow .drawflow-node label {
            font-size: 12px;
            color: #aaa;
            display: block;
            margin-top: 10px;
        }
        
        /* Modal */
        .modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1000;
        }
        
        .modal-content {
            background: #16213e;
            border-radius: 15px;
            width: 400px;
            max-width: 90%;
        }
        
        .modal-header {
            padding: 20px;
            border-bottom: 1px solid #0f3460;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .modal-header h3 {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .modal-header .close {
            font-size: 24px;
            cursor: pointer;
            color: #aaa;
        }
        
        .modal-body {
            padding: 20px;
        }
        
        .modal-footer {
            padding: 15px 20px;
            border-top: 1px solid #0f3460;
            text-align: left;
        }
        
        [dir="rtl"] .modal-footer {
            text-align: right;
        }
        
        .btn-upload, .btn-primary {
            background: var(--primary-color);
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
        }
        
        .btn-upload:hover, .btn-primary:hover {
            background: var(--secondary-color);
        }
        
        .btn-primary:disabled {
            background: #555;
            cursor: not-allowed;
        }
        
        .upload-area {
            text-align: center;
            padding: 30px;
            border: 2px dashed #0f3460;
            border-radius: 10px;
        }
        
        .upload-progress {
            margin-top: 20px;
        }
        
        .progress-bar {
            background: #0f3460;
            border-radius: 10px;
            height: 10px;
            overflow: hidden;
        }
        
        .progress {
            background: var(--primary-color);
            height: 100%;
            width: 0;
            transition: width 0.3s;
        }
        
        .progress-text {
            text-align: center;
            margin-top: 10px;
            font-size: 12px;
            color: #aaa;
        }
        
        .file-info {
            margin-top: 15px;
            padding: 10px;
            background: #0f3460;
            border-radius: 8px;
            font-size: 13px;
        }
    </style>

    <script>
        @if(isset($flow))
            window.flow_id = "{{ $flow->id }}";
            window.dataToImport = {!! $flow->flow_data !!};
        @else
            window.flow_id = null;
            window.dataToImport = {};
        @endif
        
        window.csrf_token = "{{ csrf_token() }}";
        window.save_url = "{{ route('flows.save') }}";
    </script>
</head>

<body>
    <!-- Upload Modal -->
    <div id="uploadModal" class="modal" style="display: none;">
        <div class="modal-content">
            <div class="modal-header">
                <h3><i class="las la-cloud-upload-alt"></i> رفع ملف</h3>
                <span class="close" id="closeModal">&times;</span>
            </div>
            <div class="modal-body">
                <div class="upload-area">
                    <input type="file" id="fileInput" style="display: none;">
                    <button id="uploadButton" class="btn-upload">
                        <i class="las la-cloud-upload-alt"></i> اختيار ملف
                    </button>
                    <div id="fileInfo" class="file-info" style="display: none;"></div>
                </div>
                <div id="uploadProgress" class="upload-progress" style="display: none;">
                    <div class="progress-bar">
                        <div id="progressBar" class="progress"></div>
                    </div>
                    <div id="progressText" class="progress-text">جاري الرفع...</div>
                </div>
            </div>
            <div class="modal-footer">
                <button id="startUpload" class="btn-primary" disabled>رفع</button>
            </div>
        </div>
    </div>

    <div class="wrapper">
        <div class="col">
            <div class="drag-drawflow" draggable="true" ondragstart="drag(event)" data-node="sms">
                <i class="las la-sms"></i><span>مصدر SMS</span>
            </div>
            <div class="drag-drawflow" draggable="true" ondragstart="drag(event)" data-node="whatsapp">
                <i class="lab la-whatsapp"></i><span>مصدر WhatsApp</span>
            </div>
            <div class="drag-drawflow" draggable="true" ondragstart="drag(event)" data-node="condition">
                <i class="las la-filter"></i><span>شرط</span>
            </div>
            <div class="drag-drawflow" draggable="true" ondragstart="drag(event)" data-node="ai_reply">
                <i class="las la-robot"></i><span>رد ذكي AI</span>
            </div>
            <div class="drag-drawflow" draggable="true" ondragstart="drag(event)" data-node="send_text">
                <i class="las la-comment-alt"></i><span>إرسال نص</span>
            </div>
            <div class="drag-drawflow whatsapp-only" draggable="true" ondragstart="drag(event)" data-node="send_image">
                <i class="las la-image"></i><span>إرسال صورة</span>
            </div>
            <div class="drag-drawflow whatsapp-only" draggable="true" ondragstart="drag(event)" data-node="send_video">
                <i class="las la-video"></i><span>إرسال فيديو</span>
            </div>
            <div class="drag-drawflow whatsapp-only" draggable="true" ondragstart="drag(event)" data-node="send_audio">
                <i class="las la-volume-up"></i><span>إرسال صوت</span>
            </div>
            <div class="drag-drawflow whatsapp-only" draggable="true" ondragstart="drag(event)" data-node="send_document">
                <i class="las la-file"></i><span>إرسال مستند</span>
            </div>
            <div class="drag-drawflow" draggable="true" ondragstart="drag(event)" data-node="save_contact">
                <i class="las la-address-book"></i><span>حفظ جهة اتصال</span>
            </div>
            <div class="drag-drawflow" draggable="true" ondragstart="drag(event)" data-node="pause">
                <i class="las la-pause"></i><span>إيقاف مؤقت</span>
            </div>
            <div class="drag-drawflow" draggable="true" ondragstart="drag(event)" data-node="resume">
                <i class="las la-play"></i><span>استئناف</span>
            </div>
        </div>
        
        <div class="col-right">
            <div id="drawflow" ondrop="drop(event)" ondragover="allowDrop(event)">
                <div class="btn-export" onclick="exportFlow()">حفظ</div>
                <div class="btn-clear" onclick="clearFlow()">مسح</div>

                <div class="bar-zoom">
                    <i class="las la-search-minus" onclick="editor.zoom_out()" title="تصغير"></i>
                    <i class="las la-search" onclick="editor.zoom_reset()" title="إعادة تعيين"></i>
                    <i class="las la-search-plus" onclick="editor.zoom_in()" title="تكبير"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Drawflow JS -->
    <script src="https://cdn.jsdelivr.net/gh/jerosoler/Drawflow/dist/drawflow.min.js"></script>
    
    <script>
        var id = document.getElementById("drawflow");
        var editor = new Drawflow(id);
        editor.reroute = true;
        editor.start();
        
        // Import existing flow data
        if (Object.keys(window.dataToImport).length > 0) {
            editor.import(window.dataToImport);
        }
        
        function allowDrop(ev) {
            ev.preventDefault();
        }
        
        function drag(ev) {
            ev.dataTransfer.setData("node", ev.target.getAttribute('data-node'));
        }
        
        function drop(ev) {
            ev.preventDefault();
            var nodeType = ev.dataTransfer.getData("node");
            addNodeToEditor(nodeType, ev.clientX, ev.clientY);
        }
        
        function addNodeToEditor(nodeType, posX, posY) {
            var nodeHtml = getNodeHtml(nodeType);
            if (nodeHtml) {
                var pos_x = posX - document.getElementById('drawflow').offsetLeft;
                var pos_y = posY - document.getElementById('drawflow').offsetTop;
                editor.addNode(nodeType, 1, 1, pos_x, pos_y, nodeType, {}, nodeHtml);
            }
        }
        
        function getNodeHtml(type) {
            switch(type) {
                case 'sms':
                    return '<div class="title-box"><i class="las la-sms"></i> مصدر SMS</div><div class="box"><label>الجهاز</label><select df-device><option value="">اختر جهاز</option></select></div>';
                case 'whatsapp':
                    return '<div class="title-box"><i class="lab la-whatsapp"></i> مصدر WhatsApp</div><div class="box"><label>الحساب</label><select df-account><option value="">اختر حساب</option></select></div>';
                case 'condition':
                    return '<div class="title-box"><i class="las la-filter"></i> شرط</div><div class="box"><label>النوع</label><select df-type><option value="contains">يحتوي على</option><option value="equals">يساوي</option><option value="starts">يبدأ بـ</option><option value="ends">ينتهي بـ</option></select><label>القيمة</label><input type="text" df-value placeholder="أدخل القيمة"></div>';
                case 'ai_reply':
                    return '<div class="title-box"><i class="las la-robot"></i> رد ذكي AI</div><div class="box"><label>مفتاح AI</label><select df-aikey><option value="">اختر مفتاح</option></select></div>';
                case 'send_text':
                    return '<div class="title-box"><i class="las la-comment-alt"></i> إرسال نص</div><div class="box"><label>الرسالة</label><textarea df-message rows="3" placeholder="أدخل الرسالة"></textarea></div>';
                case 'send_image':
                    return '<div class="title-box"><i class="las la-image"></i> إرسال صورة</div><div class="box"><label>رابط الصورة</label><input type="text" df-url placeholder="https://..."><label>التعليق</label><input type="text" df-caption placeholder="اختياري"></div>';
                case 'send_video':
                    return '<div class="title-box"><i class="las la-video"></i> إرسال فيديو</div><div class="box"><label>رابط الفيديو</label><input type="text" df-url placeholder="https://..."><label>التعليق</label><input type="text" df-caption placeholder="اختياري"></div>';
                case 'send_audio':
                    return '<div class="title-box"><i class="las la-volume-up"></i> إرسال صوت</div><div class="box"><label>رابط الصوت</label><input type="text" df-url placeholder="https://..."></div>';
                case 'send_document':
                    return '<div class="title-box"><i class="las la-file"></i> إرسال مستند</div><div class="box"><label>رابط المستند</label><input type="text" df-url placeholder="https://..."><label>اسم الملف</label><input type="text" df-filename placeholder="document.pdf"></div>';
                case 'save_contact':
                    return '<div class="title-box"><i class="las la-address-book"></i> حفظ جهة اتصال</div><div class="box"><label>المجموعة</label><select df-group><option value="">اختر مجموعة</option></select></div>';
                case 'pause':
                    return '<div class="title-box"><i class="las la-pause"></i> إيقاف مؤقت</div><div class="box"><label>المدة (ثواني)</label><input type="number" df-duration value="60" min="1"></div>';
                case 'resume':
                    return '<div class="title-box"><i class="las la-play"></i> استئناف</div><div class="box"><p style="font-size:12px;color:#aaa;">استئناف المحادثات المتوقفة</p></div>';
                default:
                    return null;
            }
        }
        
        function exportFlow() {
            var data = editor.export();
            
            fetch(window.save_url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': window.csrf_token
                },
                body: JSON.stringify({
                    id: window.flow_id,
                    flow_data: JSON.stringify(data)
                })
            })
            .then(response => response.json())
            .then(result => {
                if (result.success) {
                    alert('تم حفظ الـ Flow بنجاح!');
                    if (result.id && !window.flow_id) {
                        window.flow_id = result.id;
                    }
                } else {
                    alert('خطأ في الحفظ: ' + (result.error || 'خطأ غير معروف'));
                }
            })
            .catch(error => {
                alert('خطأ في الاتصال');
                console.error(error);
            });
        }
        
        function clearFlow() {
            if (confirm('هل أنت متأكد من مسح جميع العناصر؟')) {
                editor.clearModuleSelected();
            }
        }
        
        // Modal handling
        document.getElementById('closeModal').onclick = function() {
            document.getElementById('uploadModal').style.display = 'none';
        };
    </script>
</body>
</html>
