<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ __('flow_builder') }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body { overflow: hidden; }
        .flow-container { height: 100vh; display: flex; flex-direction: column; }
        .flow-header { background: #343a40; color: #fff; padding: 12px 20px; display: flex; align-items: center; justify-content: space-between; }
        .flow-body { display: flex; flex: 1; overflow: hidden; }
        .flow-sidebar { width: 280px; background: #f8f9fa; border-right: 1px solid #dee2e6; padding: 15px; overflow-y: auto; }
        .flow-canvas { flex: 1; background: #e9ecef; position: relative; overflow: auto; }
        .flow-node { position: absolute; width: 200px; background: #fff; border: 2px solid #6c757d; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); cursor: move; }
        .flow-node-header { padding: 10px; background: #6c757d; color: #fff; border-radius: 6px 6px 0 0; font-weight: 500; }
        .flow-node-body { padding: 10px; }
        .flow-node.trigger { border-color: #28a745; }
        .flow-node.trigger .flow-node-header { background: #28a745; }
        .flow-node.action { border-color: #007bff; }
        .flow-node.action .flow-node-header { background: #007bff; }
        .flow-node.condition { border-color: #ffc107; }
        .flow-node.condition .flow-node-header { background: #ffc107; color: #000; }
        .node-template { background: #fff; border: 1px solid #dee2e6; border-radius: 6px; padding: 10px; margin-bottom: 10px; cursor: pointer; }
        .node-template:hover { background: #e9ecef; }
        .connection-line { stroke: #6c757d; stroke-width: 2; fill: none; }
    </style>
</head>
<body>
    <div class="flow-container">
        <div class="flow-header">
            <div class="d-flex align-items-center">
                <a href="{{ route('dashboard.tools.flows') }}" class="btn btn-outline-light btn-sm me-3">
                    <i class="bi bi-arrow-left"></i>
                </a>
                <input type="text" class="form-control form-control-sm bg-dark text-white border-secondary" value="{{ $flow->name ?? __('new_flow') }}" id="flowName" style="width: 200px;">
            </div>
            <div>
                <button class="btn btn-outline-light btn-sm me-2" id="previewBtn">
                    <i class="bi bi-play"></i> {{ __('preview') }}
                </button>
                <button class="btn btn-success btn-sm" id="saveBtn">
                    <i class="bi bi-save"></i> {{ __('save') }}
                </button>
            </div>
        </div>
        
        <div class="flow-body">
            <div class="flow-sidebar">
                <h6 class="mb-3">{{ __('triggers') }}</h6>
                <div class="node-template" data-type="trigger" data-subtype="message_received">
                    <i class="bi bi-envelope text-success"></i> {{ __('message_received') }}
                </div>
                <div class="node-template" data-type="trigger" data-subtype="keyword">
                    <i class="bi bi-hash text-success"></i> {{ __('keyword_match') }}
                </div>
                
                <h6 class="mt-4 mb-3">{{ __('actions') }}</h6>
                <div class="node-template" data-type="action" data-subtype="send_message">
                    <i class="bi bi-chat-dots text-primary"></i> {{ __('send_message') }}
                </div>
                <div class="node-template" data-type="action" data-subtype="send_media">
                    <i class="bi bi-image text-primary"></i> {{ __('send_media') }}
                </div>
                <div class="node-template" data-type="action" data-subtype="add_to_group">
                    <i class="bi bi-people text-primary"></i> {{ __('add_to_group') }}
                </div>
                <div class="node-template" data-type="action" data-subtype="webhook">
                    <i class="bi bi-globe text-primary"></i> {{ __('call_webhook') }}
                </div>
                <div class="node-template" data-type="action" data-subtype="delay">
                    <i class="bi bi-clock text-primary"></i> {{ __('delay') }}
                </div>
                
                <h6 class="mt-4 mb-3">{{ __('conditions') }}</h6>
                <div class="node-template" data-type="condition" data-subtype="if_else">
                    <i class="bi bi-signpost-split text-warning"></i> {{ __('if_else') }}
                </div>
            </div>
            
            <div class="flow-canvas" id="flowCanvas">
                <svg id="connectionsSvg" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; pointer-events: none;"></svg>
                <!-- Flow nodes will be rendered here -->
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Flow Builder JavaScript
        let nodes = [];
        let connections = [];
        let nodeId = 0;
        
        document.querySelectorAll('.node-template').forEach(template => {
            template.addEventListener('click', function() {
                createNode(this.dataset.type, this.dataset.subtype);
            });
        });
        
        function createNode(type, subtype) {
            const id = ++nodeId;
            const node = {
                id,
                type,
                subtype,
                x: 50 + (nodes.length * 50) % 400,
                y: 50 + Math.floor(nodes.length / 4) * 150,
                config: {}
            };
            nodes.push(node);
            renderNode(node);
        }
        
        function renderNode(node) {
            const canvas = document.getElementById('flowCanvas');
            const div = document.createElement('div');
            div.className = `flow-node ${node.type}`;
            div.id = `node-${node.id}`;
            div.style.left = `${node.x}px`;
            div.style.top = `${node.y}px`;
            div.innerHTML = `
                <div class="flow-node-header d-flex justify-content-between align-items-center">
                    <span>${node.subtype.replace(/_/g, ' ')}</span>
                    <button class="btn btn-sm text-white" onclick="deleteNode(${node.id})">
                        <i class="bi bi-x"></i>
                    </button>
                </div>
                <div class="flow-node-body">
                    <small class="text-muted">{{ __('click_to_configure') }}</small>
                </div>
            `;
            makeDraggable(div);
            canvas.appendChild(div);
        }
        
        function makeDraggable(element) {
            let pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0;
            element.querySelector('.flow-node-header').onmousedown = dragMouseDown;
            
            function dragMouseDown(e) {
                e.preventDefault();
                pos3 = e.clientX;
                pos4 = e.clientY;
                document.onmouseup = closeDragElement;
                document.onmousemove = elementDrag;
            }
            
            function elementDrag(e) {
                e.preventDefault();
                pos1 = pos3 - e.clientX;
                pos2 = pos4 - e.clientY;
                pos3 = e.clientX;
                pos4 = e.clientY;
                element.style.top = (element.offsetTop - pos2) + 'px';
                element.style.left = (element.offsetLeft - pos1) + 'px';
            }
            
            function closeDragElement() {
                document.onmouseup = null;
                document.onmousemove = null;
            }
        }
        
        function deleteNode(id) {
            nodes = nodes.filter(n => n.id !== id);
            document.getElementById(`node-${id}`).remove();
        }
        
        document.getElementById('saveBtn').addEventListener('click', function() {
            const flowData = {
                name: document.getElementById('flowName').value,
                nodes,
                connections
            };
            
            fetch('/api/flows/save', {
                method: 'POST',
                headers: {'Content-Type': 'application/json', 'X-CSRF-TOKEN': '{{ csrf_token() }}'},
                body: JSON.stringify(flowData)
            }).then(r => r.json()).then(data => {
                alert('{{ __('flow_saved') }}');
            });
        });
    </script>
</body>
</html>
