@extends('layouts.app')

@section('title', __('and_dash_pg_doc_line34'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">{{ __('webhooks_documentation') }}</h6>
                </div>
                <div class="list-group list-group-flush">
                    <a href="#overview" class="list-group-item list-group-item-action">{{ __('overview') }}</a>
                    <a href="#setup" class="list-group-item list-group-item-action">{{ __('setup') }}</a>
                    <a href="#events" class="list-group-item list-group-item-action">{{ __('events') }}</a>
                    <a href="#payload" class="list-group-item list-group-item-action">{{ __('payload_format') }}</a>
                    <a href="#security" class="list-group-item list-group-item-action">{{ __('security') }}</a>
                </div>
            </div>
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-body">
                    <section id="overview" class="mb-5">
                        <h3>{{ __('overview') }}</h3>
                        <p>{{ __('webhooks_overview_text') }}</p>
                    </section>
                    
                    <section id="setup" class="mb-5">
                        <h3>{{ __('setup') }}</h3>
                        <ol>
                            <li>{{ __('webhook_step1') }}</li>
                            <li>{{ __('webhook_step2') }}</li>
                            <li>{{ __('webhook_step3') }}</li>
                            <li>{{ __('webhook_step4') }}</li>
                        </ol>
                    </section>
                    
                    <section id="events" class="mb-5">
                        <h3>{{ __('events') }}</h3>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>{{ __('event') }}</th>
                                    <th>{{ __('description') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr><td><code>message.received</code></td><td>{{ __('event_message_received') }}</td></tr>
                                <tr><td><code>message.sent</code></td><td>{{ __('event_message_sent') }}</td></tr>
                                <tr><td><code>message.delivered</code></td><td>{{ __('event_message_delivered') }}</td></tr>
                                <tr><td><code>message.read</code></td><td>{{ __('event_message_read') }}</td></tr>
                                <tr><td><code>message.failed</code></td><td>{{ __('event_message_failed') }}</td></tr>
                                <tr><td><code>device.connected</code></td><td>{{ __('event_device_connected') }}</td></tr>
                                <tr><td><code>device.disconnected</code></td><td>{{ __('event_device_disconnected') }}</td></tr>
                            </tbody>
                        </table>
                    </section>
                    
                    <section id="payload" class="mb-5">
                        <h3>{{ __('payload_format') }}</h3>
                        <div class="bg-dark text-light p-3 rounded">
                            <pre class="mb-0 text-light"><code>{
  "event": "message.received",
  "timestamp": 1699999999,
  "data": {
    "id": 12345,
    "phone": "+1234567890",
    "message": "Hello World",
    "type": "text",
    "device_id": 1,
    "received_at": "2024-01-01 12:00:00"
  }
}</code></pre>
                        </div>
                    </section>
                    
                    <section id="security" class="mb-5">
                        <h3>{{ __('security') }}</h3>
                        <p>{{ __('webhook_security_text') }}</p>
                        <div class="bg-dark text-light p-3 rounded">
                            <pre class="mb-0 text-light"><code>X-Webhook-Signature: sha256=HMAC_SIGNATURE</code></pre>
                        </div>
                        <p class="mt-3">{{ __('webhook_verify_signature') }}:</p>
                        <div class="bg-dark text-light p-3 rounded">
                            <pre class="mb-0 text-light"><code>$signature = hash_hmac('sha256', $payload, $secret);
if (hash_equals($signature, $receivedSignature)) {
    // Valid signature
}</code></pre>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
