@extends('layouts.app')

@section('title', __('and_dash_pg_doc_line52'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">{{ __('partners_documentation') }}</h6>
                </div>
                <div class="list-group list-group-flush">
                    <a href="#overview" class="list-group-item list-group-item-action">{{ __('overview') }}</a>
                    <a href="#benefits" class="list-group-item list-group-item-action">{{ __('benefits') }}</a>
                    <a href="#requirements" class="list-group-item list-group-item-action">{{ __('requirements') }}</a>
                    <a href="#earnings" class="list-group-item list-group-item-action">{{ __('earnings') }}</a>
                    <a href="#payout" class="list-group-item list-group-item-action">{{ __('payout') }}</a>
                </div>
            </div>
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-body">
                    <section id="overview" class="mb-5">
                        <h3>{{ __('overview') }}</h3>
                        <p>{{ __('partners_overview_text') }}</p>
                    </section>
                    
                    <section id="benefits" class="mb-5">
                        <h3>{{ __('benefits') }}</h3>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h5><i class="bi bi-cash text-success"></i> {{ __('earn_money') }}</h5>
                                        <p>{{ __('partner_benefit1') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h5><i class="bi bi-graph-up text-primary"></i> {{ __('passive_income') }}</h5>
                                        <p>{{ __('partner_benefit2') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                    
                    <section id="requirements" class="mb-5">
                        <h3>{{ __('requirements') }}</h3>
                        <ul>
                            <li>{{ __('partner_req1') }}</li>
                            <li>{{ __('partner_req2') }}</li>
                            <li>{{ __('partner_req3') }}</li>
                        </ul>
                    </section>
                    
                    <section id="earnings" class="mb-5">
                        <h3>{{ __('earnings') }}</h3>
                        <p>{{ __('partner_earnings_text') }}</p>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>{{ __('tier') }}</th>
                                    <th>{{ __('messages_sent') }}</th>
                                    <th>{{ __('rate_per_message') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr><td>Bronze</td><td>0 - 1,000</td><td>$0.001</td></tr>
                                <tr><td>Silver</td><td>1,001 - 10,000</td><td>$0.002</td></tr>
                                <tr><td>Gold</td><td>10,001 - 100,000</td><td>$0.003</td></tr>
                                <tr><td>Platinum</td><td>100,001+</td><td>$0.004</td></tr>
                            </tbody>
                        </table>
                    </section>
                    
                    <section id="payout" class="mb-5">
                        <h3>{{ __('payout') }}</h3>
                        <p>{{ __('partner_payout_text') }}</p>
                        <ul>
                            <li>{{ __('min_payout') }}: $10.00</li>
                            <li>{{ __('payout_methods') }}: PayPal, Bank Transfer</li>
                            <li>{{ __('payout_schedule') }}: {{ __('weekly') }}</li>
                        </ul>
                    </section>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
