@extends('layouts.admin')

@section('title', __('and_admin_api_3'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">{{ __('admin_api_documentation') }}</h6>
                </div>
                <div class="list-group list-group-flush">
                    <a href="#overview" class="list-group-item list-group-item-action">{{ __('overview') }}</a>
                    <a href="#authentication" class="list-group-item list-group-item-action">{{ __('authentication') }}</a>
                    <a href="#users" class="list-group-item list-group-item-action">{{ __('users') }}</a>
                    <a href="#packages" class="list-group-item list-group-item-action">{{ __('packages') }}</a>
                    <a href="#subscriptions" class="list-group-item list-group-item-action">{{ __('subscriptions') }}</a>
                    <a href="#transactions" class="list-group-item list-group-item-action">{{ __('transactions') }}</a>
                </div>
            </div>
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-body">
                    <section id="overview" class="mb-5">
                        <h3>{{ __('overview') }}</h3>
                        <p>{{ __('admin_api_overview_text') }}</p>
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle"></i>
                            {{ __('admin_api_warning') }}
                        </div>
                    </section>
                    
                    <section id="authentication" class="mb-5">
                        <h3>{{ __('authentication') }}</h3>
                        <p>{{ __('admin_api_auth_text') }}</p>
                        <div class="bg-dark text-light p-3 rounded">
                            <pre class="mb-0 text-light"><code>?token=YOUR_ADMIN_TOKEN</code></pre>
                        </div>
                    </section>
                    
                    <section id="users" class="mb-5">
                        <h3>{{ __('users') }}</h3>
                        <p><span class="badge bg-primary">GET</span> <code>/api/admin/get/users</code></p>
                        <p><span class="badge bg-success">POST</span> <code>/api/admin/create/user</code></p>
                        <p><span class="badge bg-warning">PUT</span> <code>/api/admin/update/user</code></p>
                        <p><span class="badge bg-danger">DELETE</span> <code>/api/admin/delete/user</code></p>
                    </section>
                    
                    <section id="packages" class="mb-5">
                        <h3>{{ __('packages') }}</h3>
                        <p><span class="badge bg-primary">GET</span> <code>/api/admin/get/packages</code></p>
                    </section>
                    
                    <section id="subscriptions" class="mb-5">
                        <h3>{{ __('subscriptions') }}</h3>
                        <p><span class="badge bg-primary">GET</span> <code>/api/admin/get/subscriptions</code></p>
                        <p><span class="badge bg-success">POST</span> <code>/api/admin/create/subscription</code></p>
                    </section>
                    
                    <section id="transactions" class="mb-5">
                        <h3>{{ __('transactions') }}</h3>
                        <p><span class="badge bg-primary">GET</span> <code>/api/admin/get/transactions</code></p>
                    </section>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
