@extends('layouts.app')

@section('title', __('Sent Messages'))
@section('page-title', __('WhatsApp Sent Messages'))

@section('content')
<div class="card">
    <div class="card-header">{{ __('Sent Messages') }}</div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>{{ __('To') }}</th>
                        <th>{{ __('Message') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Date') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($messages as $msg)
                    <tr>
                        <td>{{ $msg->phone }}</td>
                        <td>{{ Str::limit($msg->message, 50) }}</td>
                        <td>
                            @switch($msg->status)
                                @case(1)
                                    <span class="badge-status badge-warning">{{ __('Pending') }}</span>
                                    @break
                                @case(2)
                                    <span class="badge-status badge-info">{{ __('Sent') }}</span>
                                    @break
                                @case(3)
                                    <span class="badge-status badge-success">{{ __('Delivered') }}</span>
                                    @break
                                @case(4)
                                    <span class="badge-status badge-success">{{ __('Read') }}</span>
                                    @break
                                @default
                                    <span class="badge-status badge-danger">{{ __('Failed') }}</span>
                            @endswitch
                        </td>
                        <td>{{ $msg->create_date }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted py-4">{{ __('No messages sent') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        {{ $messages->links() }}
    </div>
</div>
@endsection
