@extends('layouts.app')

@section('title', __('Scan QR Code'))
@section('page-title', __('Connect WhatsApp'))

@section('content')
<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header text-center">
                <i class="bi bi-qr-code fs-1 text-success"></i>
                <h5 class="mt-2">{{ __('Scan QR Code') }}</h5>
            </div>
            <div class="card-body text-center">
                <p class="text-muted mb-4">{{ __('Open WhatsApp on your phone and scan this QR code to connect.') }}</p>
                
                <div class="qr-container mb-4">
                    <img src="data:image/png;base64,{{ $qr }}" alt="QR Code" class="img-fluid" style="max-width: 300px;">
                </div>

                <div id="status-message" class="alert alert-info">
                    <i class="bi bi-hourglass-split me-2"></i>
                    {{ __('Waiting for connection...') }}
                </div>

                <div class="d-grid gap-2">
                    <button type="button" id="check-status" class="btn btn-success">
                        <i class="bi bi-arrow-repeat me-2"></i>{{ __('Check Status') }}
                    </button>
                    <a href="{{ route('whatsapp.accounts') }}" class="btn btn-outline-secondary">
                        {{ __('Cancel') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.getElementById('check-status').addEventListener('click', function() {
    const btn = this;
    btn.disabled = true;
    btn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>{{ __('Checking...') }}';

    fetch('{{ route('whatsapp.accounts.status', $account) }}')
        .then(response => response.json())
        .then(data => {
            if (data.connected) {
                document.getElementById('status-message').className = 'alert alert-success';
                document.getElementById('status-message').innerHTML = 
                    '<i class="bi bi-check-circle me-2"></i>' +
                    '{{ __('Connected successfully!') }} ' +
                    (data.phone ? '(' + data.phone + ')' : '');
                setTimeout(() => {
                    window.location.href = '{{ route('whatsapp.accounts') }}';
                }, 1500);
            } else {
                btn.disabled = false;
                btn.innerHTML = '<i class="bi bi-arrow-repeat me-2"></i>{{ __('Check Status') }}';
            }
        })
        .catch(error => {
            btn.disabled = false;
            btn.innerHTML = '<i class="bi bi-arrow-repeat me-2"></i>{{ __('Check Status') }}';
        });
});

// Auto-check every 5 seconds
setInterval(() => {
    document.getElementById('check-status').click();
}, 5000);
</script>
@endpush
