@extends('layouts.app')

@section('title', __('Received Messages'))
@section('page-title', __('WhatsApp Received Messages'))

@section('content')
<div class="card">
    <div class="card-header">{{ __('Received Messages') }}</div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>{{ __('From') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Message') }}</th>
                        <th>{{ __('Date') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($messages as $msg)
                    <tr>
                        <td>{{ $msg->phone }}</td>
                        <td>{{ $msg->wa_name ?? '-' }}</td>
                        <td>{{ Str::limit($msg->message, 50) }}</td>
                        <td>{{ $msg->receive_date }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted py-4">{{ __('No messages received') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        {{ $messages->links() }}
    </div>
</div>
@endsection
