@extends('layouts.app')
@section('title', __('WhatsApp Groups'))
@section('page-title', __('WhatsApp Groups'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Groups') }}</span>
        <form method="POST" action="{{ route('whatsapp.groups.sync') }}" class="d-flex gap-2">
            @csrf
            <select name="account_id" class="form-control form-control-sm" required>@foreach($accounts as $a)<option value="{{ $a->id }}">{{ $a->phone ?? $a->unique }}</option>@endforeach</select>
            <button type="submit" class="btn btn-success btn-sm"><i class="bi bi-arrow-repeat me-1"></i>{{ __('Sync Groups') }}</button>
        </form>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Name') }}</th><th>{{ __('JID') }}</th><th>{{ __('Members') }}</th><th>{{ __('Account') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($groups as $g)
            <tr><td>{{ $g->name }}</td><td><small class="text-muted">{{ $g->jid }}</small></td><td>{{ $g->members }}</td><td>{{ $g->account->phone ?? $g->account->unique ?? '-' }}</td>
            <td><button class="btn btn-outline-primary btn-sm" onclick="loadMembers({{ $g->id }})"><i class="bi bi-people"></i></button></td></tr>
            @empty<tr><td colspan="5" class="text-center text-muted py-4">{{ __('No groups synced') }}</td></tr>@endforelse
        </tbody></table></div>{{ $groups->links() }}
    </div>
</div>
@push('scripts')
<script>
function loadMembers(groupId) {
    alert('Members will be loaded for group: ' + groupId);
}
</script>
@endpush
@endsection
