@extends('layouts.app')
@section('title', __('Template Categories'))
@section('page-title', __('Template Categories'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Categories') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Add Category') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Name') }}</th><th>{{ __('Templates') }}</th><th>{{ __('Created') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($categories as $c)
            <tr><td>{{ $c->name }}</td><td>{{ $c->templates_count }}</td><td>{{ $c->create_date }}</td>
            <td><button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal{{ $c->id }}"><i class="bi bi-pencil"></i></button>
            <form action="{{ route('tools.template-categories.destroy', $c) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="4" class="text-center text-muted py-4">{{ __('No categories') }}</td></tr>@endforelse
        </tbody></table></div>{{ $categories->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('tools.template-categories.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Add Category') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" required></div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Save') }}</button></div>
</form></div></div></div>
@foreach($categories as $c)
<div class="modal fade" id="editModal{{ $c->id }}" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('tools.template-categories.update', $c) }}">@csrf @method('PUT')
    <div class="modal-header"><h5 class="modal-title">{{ __('Edit Category') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" value="{{ $c->name }}" required></div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Update') }}</button></div>
</form></div></div></div>
@endforeach
@endsection
