@extends('layouts.app')

@section('title', __('dashboard_tools_logger_title'))

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">{{ __('dashboard_tools_logger_title') }}</h5>
            <form action="{{ route('dashboard.tools.logger.clear') }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('{{ __('confirm_clear_logs') }}')">
                    <i class="bi bi-trash"></i> {{ __('clear_logs') }}
                </button>
            </form>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped" id="loggerTable">
                    <thead>
                        <tr>
                            <th>{{ __('date') }}</th>
                            <th>{{ __('level') }}</th>
                            <th>{{ __('message') }}</th>
                            <th>{{ __('context') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($logs ?? [] as $log)
                        <tr>
                            <td>{{ $log->created_at }}</td>
                            <td>
                                <span class="badge bg-{{ $log->level == 'error' ? 'danger' : ($log->level == 'warning' ? 'warning' : 'info') }}">
                                    {{ $log->level }}
                                </span>
                            </td>
                            <td>{{ Str::limit($log->message, 100) }}</td>
                            <td><code>{{ Str::limit($log->context, 50) }}</code></td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="text-center">{{ __('no_logs') }}</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
