@extends('layouts.app')
@section('title', __('Auto-Reply Actions'))
@section('page-title', __('Auto-Reply Actions'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Actions') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Add Action') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Priority') }}</th><th>{{ __('Name') }}</th><th>{{ __('Type') }}</th><th>{{ __('Keywords') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($actions as $a)
            <tr><td><span class="badge bg-secondary">{{ $a->priority }}</span></td><td>{{ $a->name }}</td>
            <td>@if($a->type == 1)<span class="badge bg-primary">SMS</span>@else<span class="badge bg-success">WhatsApp</span>@endif</td>
            <td>{{ Str::limit($a->keywords, 30) }}</td>
            <td><button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal{{ $a->id }}"><i class="bi bi-pencil"></i></button>
            <form action="{{ route('tools.actions.destroy', $a) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="5" class="text-center text-muted py-4">{{ __('No actions') }}</td></tr>@endforelse
        </tbody></table></div>{{ $actions->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><form method="POST" action="{{ route('tools.actions.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Add Action') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body">
        <div class="row"><div class="col-md-6 mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" required></div>
        <div class="col-md-3 mb-3"><label class="form-label">{{ __('Type') }}</label><select name="type" class="form-control" required><option value="1">SMS</option><option value="2">WhatsApp</option></select></div>
        <div class="col-md-3 mb-3"><label class="form-label">{{ __('Priority') }}</label><input type="number" name="priority" class="form-control" value="1" min="1"></div></div>
        <div class="row"><div class="col-md-6 mb-3"><label class="form-label">{{ __('Source') }}</label><select name="source" class="form-control"><option value="1">{{ __('Incoming') }}</option><option value="2">{{ __('Outgoing') }}</option></select></div>
        <div class="col-md-6 mb-3"><label class="form-label">{{ __('Event') }}</label><select name="event" class="form-control"><option value="1">{{ __('Message Received') }}</option><option value="2">{{ __('Message Sent') }}</option></select></div></div>
        <div class="mb-3"><label class="form-label">{{ __('Keywords') }}</label><input type="text" name="keywords" class="form-control" placeholder="{{ __('Comma separated keywords') }}" required></div>
        <div class="mb-3"><label class="form-label">{{ __('Reply Message') }}</label><textarea name="message" class="form-control" rows="4" required></textarea></div>
    </div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Save') }}</button></div>
</form></div></div></div>
@foreach($actions as $a)
<div class="modal fade" id="editModal{{ $a->id }}" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><form method="POST" action="{{ route('tools.actions.update', $a) }}">@csrf @method('PUT')
    <div class="modal-header"><h5 class="modal-title">{{ __('Edit Action') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body">
        <div class="row"><div class="col-md-6 mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" value="{{ $a->name }}" required></div>
        <div class="col-md-3 mb-3"><label class="form-label">{{ __('Type') }}</label><select name="type" class="form-control"><option value="1" @if($a->type==1)selected @endif>SMS</option><option value="2" @if($a->type==2)selected @endif>WhatsApp</option></select></div>
        <div class="col-md-3 mb-3"><label class="form-label">{{ __('Priority') }}</label><input type="number" name="priority" class="form-control" value="{{ $a->priority }}" min="1"></div></div>
        <div class="mb-3"><label class="form-label">{{ __('Keywords') }}</label><input type="text" name="keywords" class="form-control" value="{{ $a->keywords }}" required></div>
        <div class="mb-3"><label class="form-label">{{ __('Reply Message') }}</label><textarea name="message" class="form-control" rows="4" required>{{ $a->message }}</textarea></div>
    </div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Update') }}</button></div>
</form></div></div></div>
@endforeach
@endsection
