@extends('layouts.app')
@section('title', __('Transactions'))
@section('page-title', __('My Transactions'))
@section('content')
<div class="card">
    <div class="card-header">{{ __('Transactions') }}</div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Package') }}</th><th>{{ __('Type') }}</th><th>{{ __('Provider') }}</th><th>{{ __('Amount') }}</th><th>{{ __('Duration') }}</th><th>{{ __('Date') }}</th></tr></thead><tbody>
            @forelse($transactions as $t)
            <tr><td>{{ $t->package->name ?? '-' }}</td><td>{{ $t->type }}</td><td>{{ $t->provider }}</td><td>{{ $t->currency }} {{ number_format($t->price, 2) }}</td><td>{{ $t->duration }} {{ __('days') }}</td><td>{{ $t->create_date }}</td></tr>
            @empty<tr><td colspan="6" class="text-center text-muted py-4">{{ __('No transactions') }}</td></tr>@endforelse
        </tbody></table></div>{{ $transactions->links() }}
    </div>
</div>
@endsection
