@extends('layouts.app')
@section('title', __('SMS Sent'))
@section('page-title', __('Sent SMS Messages'))
@section('content')
<div class="card">
    <div class="card-header">{{ __('Sent Messages') }}</div>
    <div class="card-body">
        <form method="GET" class="row g-3 mb-4">
            <div class="col-md-4"><input type="text" name="search" class="form-control" placeholder="{{ __('Search...') }}" value="{{ request('search') }}"></div>
            <div class="col-md-2"><select name="status" class="form-control"><option value="">{{ __('All Status') }}</option><option value="1">{{ __('Pending') }}</option><option value="2">{{ __('Sent') }}</option><option value="3">{{ __('Delivered') }}</option><option value="4">{{ __('Failed') }}</option></select></div>
            <div class="col-md-2"><button type="submit" class="btn btn-outline-primary">{{ __('Filter') }}</button></div>
        </form>
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('To') }}</th><th>{{ __('Message') }}</th><th>{{ __('Status') }}</th><th>{{ __('Date') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($messages as $msg)
            <tr><td>{{ $msg->phone }}</td><td>{{ Str::limit($msg->message, 40) }}</td>
            <td>@if($msg->status == 1)<span class="badge bg-warning">{{ __('Pending') }}</span>@elseif($msg->status == 2)<span class="badge bg-info">{{ __('Sent') }}</span>@elseif($msg->status == 3)<span class="badge bg-success">{{ __('Delivered') }}</span>@else<span class="badge bg-danger">{{ __('Failed') }}</span>@endif</td>
            <td>{{ $msg->create_date }}</td><td><form action="{{ route('sms.sent.destroy', $msg) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="5" class="text-center text-muted py-4">{{ __('No messages') }}</td></tr>@endforelse
        </tbody></table></div>{{ $messages->links() }}
    </div>
</div>
@endsection
