@extends('layouts.app')
@section('title', __('SMS Scheduled'))
@section('page-title', __('Scheduled SMS'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Scheduled Messages') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Schedule New') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('To') }}</th><th>{{ __('Message') }}</th><th>{{ __('Send Date') }}</th><th>{{ __('Status') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($scheduled as $item)
            <tr><td>{{ Str::limit($item->numbers, 30) }}</td><td>{{ Str::limit($item->message, 40) }}</td><td>{{ $item->send_date }}</td>
            <td>@if($item->status == 1)<span class="badge bg-warning">{{ __('Pending') }}</span>@elseif($item->status == 2)<span class="badge bg-success">{{ __('Sent') }}</span>@else<span class="badge bg-danger">{{ __('Failed') }}</span>@endif</td>
            <td><form action="{{ route('sms.scheduled.destroy', $item) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="5" class="text-center text-muted py-4">{{ __('No scheduled messages') }}</td></tr>@endforelse
        </tbody></table></div>{{ $scheduled->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><form method="POST" action="{{ route('sms.scheduled.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Schedule SMS') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body">
        <div class="row"><div class="col-md-6 mb-3"><label class="form-label">{{ __('Device') }}</label><select name="did" class="form-control" required>@foreach($devices as $d)<option value="{{ $d->did }}">{{ $d->name }}</option>@endforeach</select></div>
        <div class="col-md-6 mb-3"><label class="form-label">{{ __('Send Date') }}</label><input type="datetime-local" name="send_date" class="form-control" required></div></div>
        <div class="mb-3"><label class="form-label">{{ __('Numbers') }}</label><textarea name="numbers" class="form-control" rows="3" placeholder="{{ __('One number per line') }}" required></textarea></div>
        <div class="mb-3"><label class="form-label">{{ __('Message') }}</label><textarea name="message" class="form-control" rows="4" required></textarea></div>
    </div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Schedule') }}</button></div>
</form></div></div></div>
@endsection
