@extends('layouts.app')
@section('title', __('SMS Received'))
@section('page-title', __('Received SMS Messages'))
@section('content')
<div class="card">
    <div class="card-header">{{ __('Received Messages') }}</div>
    <div class="card-body">
        <form method="GET" class="row g-3 mb-4"><div class="col-md-4"><input type="text" name="search" class="form-control" placeholder="{{ __('Search...') }}" value="{{ request('search') }}"></div><div class="col-md-2"><button type="submit" class="btn btn-outline-primary">{{ __('Search') }}</button></div></form>
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('From') }}</th><th>{{ __('Message') }}</th><th>{{ __('Device') }}</th><th>{{ __('Date') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($messages as $msg)
            <tr><td>{{ $msg->phone }}</td><td>{{ Str::limit($msg->message, 50) }}</td><td>{{ $msg->did }}</td><td>{{ $msg->receive_date }}</td><td><form action="{{ route('sms.received.destroy', $msg) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="5" class="text-center text-muted py-4">{{ __('No messages') }}</td></tr>@endforelse
        </tbody></table></div>{{ $messages->links() }}
    </div>
</div>
@endsection
