@extends('layouts.app')
@section('title', __('SMS Campaigns'))
@section('page-title', __('SMS Campaigns'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Campaigns') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('New Campaign') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Name') }}</th><th>{{ __('Contacts') }}</th><th>{{ __('Status') }}</th><th>{{ __('Created') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($campaigns as $c)
            <tr><td>{{ $c->name }}</td><td>{{ $c->contacts }}</td>
            <td>@if($c->status == 1)<span class="badge bg-warning">{{ __('Pending') }}</span>@elseif($c->status == 2)<span class="badge bg-info">{{ __('Running') }}</span>@else<span class="badge bg-success">{{ __('Completed') }}</span>@endif</td>
            <td>{{ $c->create_date }}</td><td><form action="{{ route('sms.campaigns.destroy', $c) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="5" class="text-center text-muted py-4">{{ __('No campaigns') }}</td></tr>@endforelse
        </tbody></table></div>{{ $campaigns->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('sms.campaigns.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('New Campaign') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="mb-3"><label class="form-label">{{ __('Campaign Name') }}</label><input type="text" name="name" class="form-control" required></div><div class="mb-3"><label class="form-label">{{ __('Device') }}</label><input type="text" name="did" class="form-control" required></div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Create') }}</button></div>
</form></div></div></div>
@endsection
