@extends('layouts.app')
@section('title', __('Messages Report'))
@section('page-title', __('Messages Report'))
@section('content')
<div class="card">
    <div class="card-header">
        <form method="GET" class="row g-2">
            <div class="col-md-3"><select name="type" class="form-control"><option value="whatsapp" @if($type=='whatsapp')selected @endif>WhatsApp</option><option value="sms" @if($type=='sms')selected @endif>SMS</option></select></div>
            <div class="col-md-3"><select name="status" class="form-control"><option value="">{{ __('All Status') }}</option><option value="1">{{ __('Pending') }}</option><option value="2">{{ __('Sent') }}</option><option value="3">{{ __('Delivered') }}</option><option value="5">{{ __('Failed') }}</option></select></div>
            <div class="col-md-2"><button type="submit" class="btn btn-primary btn-sm">{{ __('Filter') }}</button></div>
        </form>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('To') }}</th><th>{{ __('Message') }}</th><th>{{ __('Status') }}</th><th>{{ __('Date') }}</th></tr></thead><tbody>
            @forelse($messages as $m)
            <tr><td>{{ $m->phone }}</td><td>{{ Str::limit($m->message, 40) }}</td>
            <td>@if($m->status == 1)<span class="badge bg-warning">Pending</span>@elseif($m->status == 2)<span class="badge bg-info">Sent</span>@elseif($m->status == 3)<span class="badge bg-success">Delivered</span>@else<span class="badge bg-danger">Failed</span>@endif</td>
            <td>{{ $m->create_date ?? $m->receive_date }}</td></tr>
            @empty<tr><td colspan="4" class="text-center text-muted">{{ __('No messages') }}</td></tr>@endforelse
        </tbody></table></div>{{ $messages->links() }}
    </div>
</div>
@endsection
