@extends('layouts.app')
@section('title', __('Reports'))
@section('page-title', __('Reports'))
@section('content')
<div class="card mb-4">
    <div class="card-header">{{ __('Filter') }}</div>
    <div class="card-body">
        <form method="GET" class="row g-3"><div class="col-md-3"><label class="form-label">{{ __('From') }}</label><input type="date" name="from" class="form-control" value="{{ $dateFrom }}"></div>
        <div class="col-md-3"><label class="form-label">{{ __('To') }}</label><input type="date" name="to" class="form-control" value="{{ $dateTo }}"></div>
        <div class="col-md-3 d-flex align-items-end"><button type="submit" class="btn btn-primary">{{ __('Apply') }}</button></div></form>
    </div>
</div>

<div class="row g-4 mb-4">
    <div class="col-md-3"><div class="stat-card"><div class="value">{{ number_format($smsSent) }}</div><div class="label">{{ __('SMS Sent') }}</div></div></div>
    <div class="col-md-3"><div class="stat-card"><div class="value">{{ number_format($smsReceived) }}</div><div class="label">{{ __('SMS Received') }}</div></div></div>
    <div class="col-md-3"><div class="stat-card"><div class="value">{{ number_format($waSent) }}</div><div class="label">{{ __('WhatsApp Sent') }}</div></div></div>
    <div class="col-md-3"><div class="stat-card"><div class="value">{{ number_format($waReceived) }}</div><div class="label">{{ __('WhatsApp Received') }}</div></div></div>
</div>

<div class="card">
    <div class="card-header">{{ __('Activity Chart') }}</div>
    <div class="card-body"><canvas id="reportChart" height="300"></canvas></div>
</div>
@push('scripts')
<script>
const ctx = document.getElementById('reportChart').getContext('2d');
new Chart(ctx, {
    type: 'line',
    data: {
        labels: @json($chartData['labels']),
        datasets: [{
            label: 'SMS',
            data: @json($chartData['sms']),
            borderColor: '#3b82f6',
            fill: false
        }, {
            label: 'WhatsApp',
            data: @json($chartData['whatsapp']),
            borderColor: '#10b981',
            fill: false
        }]
    },
    options: { responsive: true, maintainAspectRatio: false }
});
</script>
@endpush
@endsection
