@extends('layouts.app')

@section('title', __('Dashboard'))
@section('page-title', __('Dashboard'))

@section('content')
<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <div class="value">{{ number_format($stats['wa_sent']) }}</div>
                    <div class="label">{{ __('WhatsApp Sent') }}</div>
                </div>
                <div class="icon bg-success bg-opacity-10 text-success">
                    <i class="bi bi-whatsapp"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <div class="value">{{ number_format($stats['wa_received']) }}</div>
                    <div class="label">{{ __('WhatsApp Received') }}</div>
                </div>
                <div class="icon bg-primary bg-opacity-10 text-primary">
                    <i class="bi bi-inbox"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <div class="value">{{ number_format($stats['contacts']) }}</div>
                    <div class="label">{{ __('Contacts') }}</div>
                </div>
                <div class="icon bg-warning bg-opacity-10 text-warning">
                    <i class="bi bi-people"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <div class="value">{{ number_format($stats['wa_accounts']) }}</div>
                    <div class="label">{{ __('WhatsApp Accounts') }}</div>
                </div>
                <div class="icon bg-info bg-opacity-10 text-info">
                    <i class="bi bi-phone"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <!-- Chart -->
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span>{{ __('Message Activity') }}</span>
                <span class="text-muted small">{{ __('Last 7 days') }}</span>
            </div>
            <div class="card-body">
                <canvas id="activityChart" height="300"></canvas>
            </div>
        </div>
    </div>

    <!-- Recent Messages -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">{{ __('Recent Received') }}</div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    @forelse($recentReceived as $message)
                    <li class="list-group-item">
                        <div class="d-flex justify-content-between">
                            <strong>{{ $message->wa_name ?? $message->phone }}</strong>
                            <small class="text-muted">{{ $message->receive_date->diffForHumans() }}</small>
                        </div>
                        <small class="text-truncate d-block">{{ Str::limit($message->message, 50) }}</small>
                    </li>
                    @empty
                    <li class="list-group-item text-center text-muted">
                        {{ __('No messages yet') }}
                    </li>
                    @endforelse
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('activityChart').getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: @json($chartData['labels']),
            datasets: [{
                label: '{{ __('Sent') }}',
                data: @json($chartData['sent']),
                borderColor: '#10b981',
                backgroundColor: 'rgba(16, 185, 129, 0.1)',
                fill: true,
                tension: 0.4
            }, {
                label: '{{ __('Received') }}',
                data: @json($chartData['received']),
                borderColor: '#3b82f6',
                backgroundColor: 'rgba(59, 130, 246, 0.1)',
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
});
</script>
@endpush
