@extends('layouts.app')
@section('title', __('WhatsApp Accounts'))
@section('page-title', __('WhatsApp Accounts'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Accounts') }}</span>
        <a href="{{ route('hosts.whatsapp.create') }}" class="btn btn-success btn-sm"><i class="bi bi-qr-code me-1"></i>{{ __('Add Account') }}</a>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Phone') }}</th><th>{{ __('Name') }}</th><th>{{ __('Status') }}</th><th>{{ __('Created') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($accounts as $a)
            <tr><td>{{ $a->phone ?? '-' }}</td><td>{{ $a->name ?? '-' }}</td>
            <td>@if($a->status == 1)<span class="badge bg-success">{{ __('Connected') }}</span>@else<span class="badge bg-warning">{{ __('Disconnected') }}</span>@endif</td>
            <td>{{ $a->create_date }}</td>
            <td><button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal{{ $a->id }}"><i class="bi bi-pencil"></i></button>
            <form action="{{ route('hosts.whatsapp.destroy', $a) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm" onclick="return confirm('{{ __('Disconnect and delete?') }}')"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="5" class="text-center text-muted py-4">{{ __('No accounts') }}</td></tr>@endforelse
        </tbody></table></div>{{ $accounts->links() }}
    </div>
</div>
@foreach($accounts as $a)
<div class="modal fade" id="editModal{{ $a->id }}" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('hosts.whatsapp.update', $a) }}">@csrf @method('PUT')
    <div class="modal-header"><h5 class="modal-title">{{ __('Edit Account') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body">
        <div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" value="{{ $a->name }}"></div>
        <div class="mb-3"><label class="form-label">{{ __('Receive Chats') }}</label><select name="receive_chats" class="form-control"><option value="1" @if($a->receive_chats)selected @endif>{{ __('Yes') }}</option><option value="0" @if(!$a->receive_chats)selected @endif>{{ __('No') }}</option></select></div>
        <div class="row"><div class="col-md-4 mb-3"><label class="form-label">{{ __('Random Send') }}</label><select name="random_send" class="form-control"><option value="0" @if(!$a->random_send)selected @endif>{{ __('No') }}</option><option value="1" @if($a->random_send)selected @endif>{{ __('Yes') }}</option></select></div>
        <div class="col-md-4 mb-3"><label class="form-label">{{ __('Min (sec)') }}</label><input type="number" name="random_min" class="form-control" value="{{ $a->random_min }}"></div>
        <div class="col-md-4 mb-3"><label class="form-label">{{ __('Max (sec)') }}</label><input type="number" name="random_max" class="form-control" value="{{ $a->random_max }}"></div></div>
    </div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Update') }}</button></div>
</form></div></div></div>
@endforeach
@endsection
