@extends('layouts.app')

@section('title', __('Sources'))
@section('page-title', __('Contact Sources'))

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('All Sources') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Add Source') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead><tr><th>{{ __('Name') }}</th><th>{{ __('Description') }}</th><th>{{ __('Created') }}</th><th>{{ __('Actions') }}</th></tr></thead>
                <tbody>
                    @forelse($sources as $source)
                    <tr>
                        <td>{{ $source->name }}</td>
                        <td>{{ Str::limit($source->description, 50) }}</td>
                        <td>{{ $source->create_date }}</td>
                        <td>
                            <button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal{{ $source->id }}"><i class="bi bi-pencil"></i></button>
                            <form action="{{ route('sources.destroy', $source) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm" onclick="return confirm('{{ __('Are you sure?') }}')"><i class="bi bi-trash"></i></button></form>
                        </td>
                    </tr>
                    @empty
                    <tr><td colspan="4" class="text-center text-muted py-4">{{ __('No sources found') }}</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        {{ $sources->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('sources.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Add Source') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body">
        <div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" required></div>
        <div class="mb-3"><label class="form-label">{{ __('Description') }}</label><textarea name="description" class="form-control" rows="3"></textarea></div>
    </div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Save') }}</button></div>
</form></div></div></div>

@foreach($sources as $source)
<div class="modal fade" id="editModal{{ $source->id }}" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('sources.update', $source) }}">@csrf @method('PUT')
    <div class="modal-header"><h5 class="modal-title">{{ __('Edit Source') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body">
        <div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" value="{{ $source->name }}" required></div>
        <div class="mb-3"><label class="form-label">{{ __('Description') }}</label><textarea name="description" class="form-control" rows="3">{{ $source->description }}</textarea></div>
    </div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Update') }}</button></div>
</form></div></div></div>
@endforeach
@endsection
