@extends('layouts.app')
@section('title', __('AI Keys'))
@section('page-title', __('AI API Keys'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('AI Keys') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Add Key') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Name') }}</th><th>{{ __('Provider') }}</th><th>{{ __('Model') }}</th><th>{{ __('Created') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($keys as $k)
            <tr><td>{{ $k->name }}</td><td><span class="badge bg-primary">{{ ucfirst($k->provider) }}</span></td><td>{{ $k->model }}</td><td>{{ $k->create_date }}</td>
            <td><button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal{{ $k->id }}"><i class="bi bi-pencil"></i></button>
            <form action="{{ route('ai.keys.destroy', $k) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="5" class="text-center text-muted py-4">{{ __('No AI keys') }}</td></tr>@endforelse
        </tbody></table></div>{{ $keys->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><form method="POST" action="{{ route('ai.keys.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Add AI Key') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body">
        <div class="row"><div class="col-md-6 mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" required></div>
        <div class="col-md-6 mb-3"><label class="form-label">{{ __('Provider') }}</label><select name="provider" class="form-control" required><option value="openai">OpenAI</option><option value="anthropic">Anthropic</option><option value="google">Google</option></select></div></div>
        <div class="row"><div class="col-md-6 mb-3"><label class="form-label">{{ __('Model') }}</label><input type="text" name="model" class="form-control" value="gpt-4" required></div>
        <div class="col-md-6 mb-3"><label class="form-label">{{ __('API Key') }}</label><input type="password" name="apikey" class="form-control" required></div></div>
        <div class="mb-3"><label class="form-label">{{ __('System Prompt') }}</label><textarea name="prompt" class="form-control" rows="3"></textarea></div>
        <div class="row"><div class="col-md-4 mb-3"><label class="form-label">{{ __('Max Tokens') }}</label><input type="number" name="max_tokens" class="form-control" value="1024"></div>
        <div class="col-md-4 mb-3"><label class="form-label">{{ __('History') }}</label><input type="number" name="history" class="form-control" value="10"></div>
        <div class="col-md-4 mb-3"><label class="form-label">{{ __('Vision') }}</label><select name="vision" class="form-control"><option value="0">{{ __('No') }}</option><option value="1">{{ __('Yes') }}</option></select></div></div>
    </div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Save') }}</button></div>
</form></div></div></div>
@foreach($keys as $k)
<div class="modal fade" id="editModal{{ $k->id }}" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><form method="POST" action="{{ route('ai.keys.update', $k) }}">@csrf @method('PUT')
    <div class="modal-header"><h5 class="modal-title">{{ __('Edit AI Key') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body">
        <div class="row"><div class="col-md-6 mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" value="{{ $k->name }}" required></div>
        <div class="col-md-6 mb-3"><label class="form-label">{{ __('Provider') }}</label><select name="provider" class="form-control"><option value="openai" @if($k->provider=='openai')selected @endif>OpenAI</option><option value="anthropic" @if($k->provider=='anthropic')selected @endif>Anthropic</option><option value="google" @if($k->provider=='google')selected @endif>Google</option></select></div></div>
        <div class="row"><div class="col-md-6 mb-3"><label class="form-label">{{ __('Model') }}</label><input type="text" name="model" class="form-control" value="{{ $k->model }}"></div>
        <div class="col-md-6 mb-3"><label class="form-label">{{ __('API Key') }}</label><input type="password" name="apikey" class="form-control" placeholder="{{ __('Leave blank to keep current') }}"></div></div>
        <div class="mb-3"><label class="form-label">{{ __('System Prompt') }}</label><textarea name="prompt" class="form-control" rows="3">{{ $k->prompt }}</textarea></div>
    </div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Update') }}</button></div>
</form></div></div></div>
@endforeach
@endsection
