@extends('layouts.auth')

@section('title', __('Login'))

@section('content')
<div class="auth-card">
    <div class="auth-logo">
        <i class="bi bi-whatsapp text-success" style="font-size: 3rem;"></i>
        <h2>FlyWhats</h2>
        <p class="text-muted">{{ __('Sign in to your account') }}</p>
    </div>

    <form method="POST" action="{{ route('login') }}">
        @csrf
        
        <div class="mb-3">
            <label for="email" class="form-label">{{ __('Email Address') }}</label>
            <input type="email" class="form-control @error('email') is-invalid @enderror" 
                   id="email" name="email" value="{{ old('email') }}" required autofocus>
            @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="password" class="form-label">{{ __('Password') }}</label>
            <input type="password" class="form-control @error('password') is-invalid @enderror" 
                   id="password" name="password" required>
            @error('password')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3 form-check">
            <input type="checkbox" class="form-check-input" id="remember" name="remember">
            <label class="form-check-label" for="remember">{{ __('Remember me') }}</label>
        </div>

        <button type="submit" class="btn btn-primary w-100 mb-3">
            <i class="bi bi-box-arrow-in-right me-2"></i>{{ __('Sign In') }}
        </button>

        <div class="text-center">
            <a href="{{ route('password.request') }}" class="text-decoration-none">
                {{ __('Forgot your password?') }}
            </a>
        </div>
    </form>

    <hr class="my-4">

    <div class="text-center">
        <span class="text-muted">{{ __('Don\'t have an account?') }}</span>
        <a href="{{ route('register') }}" class="text-decoration-none ms-1">{{ __('Sign Up') }}</a>
    </div>
</div>
@endsection
