<!-- Setup WA Server Modals -->
@foreach($waservers ?? [] as $server)
<div class="modal fade" id="setupWaServerModal{{ $server->id }}" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('setup_waserver') }}: {{ $server->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <h6>{{ __('server_info') }}</h6>
                    <p class="mb-1"><strong>URL:</strong> {{ $server->url }}:{{ $server->port }}</p>
                    <p class="mb-1"><strong>Secret:</strong> <code>{{ $server->secret }}</code></p>
                    <p class="mb-0"><strong>Status:</strong> 
                        @if($server->status)
                            <span class="badge bg-success">{{ __('online') }}</span>
                        @else
                            <span class="badge bg-danger">{{ __('offline') }}</span>
                        @endif
                    </p>
                </div>
                
                <h6 class="mt-4">{{ __('cron_setup') }}</h6>
                <div class="bg-dark text-light p-3 rounded">
                    <code>
                        * * * * * curl -s "{{ $server->url }}:{{ $server->port }}/cron?secret={{ $server->secret }}" > /dev/null 2>&1
                    </code>
                </div>
                
                <h6 class="mt-4">{{ __('webhook_url') }}</h6>
                <div class="bg-dark text-light p-3 rounded">
                    <code>{{ url('/api/whatsapp/webhook') }}</code>
                </div>
                
                <h6 class="mt-4">{{ __('test_connection') }}</h6>
                <button type="button" class="btn btn-outline-primary" onclick="testWaServer({{ $server->id }})">
                    <i class="bi bi-wifi"></i> {{ __('test') }}
                </button>
                <div id="testResult{{ $server->id }}" class="mt-2"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('close') }}</button>
            </div>
        </div>
    </div>
</div>
@endforeach

<script>
function testWaServer(id) {
    const resultDiv = document.getElementById('testResult' + id);
    resultDiv.innerHTML = '<div class="spinner-border spinner-border-sm" role="status"></div> Testing...';
    
    fetch(`/api/admin/waservers/${id}/test`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                resultDiv.innerHTML = '<div class="alert alert-success mb-0">{{ __('connection_success') }}</div>';
            } else {
                resultDiv.innerHTML = '<div class="alert alert-danger mb-0">' + data.message + '</div>';
            }
        })
        .catch(error => {
            resultDiv.innerHTML = '<div class="alert alert-danger mb-0">{{ __('connection_failed') }}</div>';
        });
}
</script>
