@extends('layouts.admin')

@section('title', __('dashboard_admin_waserverstitle'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ __('dashboard_admin_waserverstitle') }}</h5>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addWaServerModal">
                        <i class="bi bi-plus-lg"></i> {{ __('add_waserver') }}
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="waserversTable">
                            <thead>
                                <tr>
                                    <th>{{ __('id') }}</th>
                                    <th>{{ __('name') }}</th>
                                    <th>{{ __('url') }}</th>
                                    <th>{{ __('port') }}</th>
                                    <th>{{ __('status') }}</th>
                                    <th>{{ __('accounts') }}</th>
                                    <th>{{ __('actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($waservers ?? [] as $server)
                                <tr>
                                    <td>{{ $server->id }}</td>
                                    <td>{{ $server->name }}</td>
                                    <td>{{ $server->url }}</td>
                                    <td>{{ $server->port }}</td>
                                    <td>
                                        @if($server->status)
                                            <span class="badge bg-success">{{ __('online') }}</span>
                                        @else
                                            <span class="badge bg-danger">{{ __('offline') }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $server->accounts_count ?? 0 }}</td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#setupWaServerModal{{ $server->id }}">
                                            <i class="bi bi-gear"></i>
                                        </button>
                                        <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editWaServerModal{{ $server->id }}">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="deleteWaServer({{ $server->id }})">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">{{ __('no_data') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.waservers.modals.add')
@include('admin.waservers.modals.edit')
@include('admin.waservers.modals.setup')
@endsection
