<!-- Edit Voucher Modals -->
@foreach($vouchers ?? [] as $voucher)
<div class="modal fade" id="editVoucherModal{{ $voucher->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('edit_voucher') }}: {{ $voucher->code }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.vouchers.update', $voucher->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('code') }}</label>
                        <input type="text" name="code" class="form-control" value="{{ $voucher->code }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('package') }}</label>
                        <select name="pid" class="form-control">
                            <option value="">{{ __('all_packages') }}</option>
                            @foreach($packages ?? [] as $package)
                            <option value="{{ $package->id }}" {{ $voucher->pid == $package->id ? 'selected' : '' }}>{{ $package->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('discount_type') }}</label>
                        <select name="type" class="form-control" required>
                            <option value="percentage" {{ $voucher->type == 'percentage' ? 'selected' : '' }}>{{ __('percentage') }}</option>
                            <option value="fixed" {{ $voucher->type == 'fixed' ? 'selected' : '' }}>{{ __('fixed_amount') }}</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('discount') }}</label>
                        <input type="number" name="discount" class="form-control" step="0.01" value="{{ $voucher->discount }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('max_uses') }}</label>
                        <input type="number" name="max_uses" class="form-control" value="{{ $voucher->max_uses }}" placeholder="{{ __('unlimited') }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('expires_at') }}</label>
                        <input type="date" name="expires_at" class="form-control" value="{{ $voucher->expires_at }}">
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" name="status" class="form-check-input" value="1" {{ $voucher->status ? 'checked' : '' }}>
                        <label class="form-check-label">{{ __('active') }}</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
