@extends('layouts.admin')

@section('title', __('dashboard_vouchers_title'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ __('dashboard_vouchers_title') }}</h5>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addVoucherModal">
                        <i class="bi bi-plus-lg"></i> {{ __('add_voucher') }}
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="vouchersTable">
                            <thead>
                                <tr>
                                    <th>{{ __('id') }}</th>
                                    <th>{{ __('code') }}</th>
                                    <th>{{ __('package') }}</th>
                                    <th>{{ __('discount') }}</th>
                                    <th>{{ __('uses') }}</th>
                                    <th>{{ __('status') }}</th>
                                    <th>{{ __('expires') }}</th>
                                    <th>{{ __('actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($vouchers ?? [] as $voucher)
                                <tr>
                                    <td>{{ $voucher->id }}</td>
                                    <td><code>{{ $voucher->code }}</code></td>
                                    <td>{{ $voucher->package->name ?? __('all_packages') }}</td>
                                    <td>
                                        @if($voucher->type == 'percentage')
                                            {{ $voucher->discount }}%
                                        @else
                                            {{ number_format($voucher->discount, 2) }}
                                        @endif
                                    </td>
                                    <td>{{ $voucher->used }}/{{ $voucher->max_uses ?: '∞' }}</td>
                                    <td>
                                        @if($voucher->status)
                                            <span class="badge bg-success">{{ __('active') }}</span>
                                        @else
                                            <span class="badge bg-danger">{{ __('inactive') }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $voucher->expires_at ?? __('never') }}</td>
                                    <td>
                                        <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editVoucherModal{{ $voucher->id }}">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="deleteVoucher({{ $voucher->id }})">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">{{ __('no_data') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.vouchers.modals.add')
@include('admin.vouchers.modals.edit')
@endsection
