<!-- Edit Subscription Modals -->
@foreach($subscriptions ?? [] as $subscription)
<div class="modal fade" id="editSubscriptionModal{{ $subscription->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('edit_subscription') }} #{{ $subscription->id }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.subscriptions.update', $subscription->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('user') }}</label>
                        <input type="text" class="form-control" value="{{ $subscription->user->name ?? 'N/A' }}" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('package') }}</label>
                        <select name="pid" class="form-control" required>
                            @foreach($packages ?? [] as $package)
                            <option value="{{ $package->id }}" {{ $subscription->pid == $package->id ? 'selected' : '' }}>
                                {{ $package->name }} - {{ $package->price }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('start_date') }}</label>
                        <input type="date" name="start_date" class="form-control" value="{{ $subscription->start_date }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('end_date') }}</label>
                        <input type="date" name="end_date" class="form-control" value="{{ $subscription->end_date }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('status') }}</label>
                        <select name="status" class="form-control" required>
                            <option value="active" {{ $subscription->status == 'active' ? 'selected' : '' }}>{{ __('active') }}</option>
                            <option value="expired" {{ $subscription->status == 'expired' ? 'selected' : '' }}>{{ __('expired') }}</option>
                            <option value="cancelled" {{ $subscription->status == 'cancelled' ? 'selected' : '' }}>{{ __('cancelled') }}</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
