@extends('layouts.admin')

@section('title', __('dashboard_admin_tabsubscriptionstitle'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ __('dashboard_admin_tabsubscriptionstitle') }}</h5>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSubscriptionModal">
                        <i class="bi bi-plus-lg"></i> {{ __('add_subscription') }}
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="subscriptionsTable">
                            <thead>
                                <tr>
                                    <th>{{ __('id') }}</th>
                                    <th>{{ __('user') }}</th>
                                    <th>{{ __('package') }}</th>
                                    <th>{{ __('start_date') }}</th>
                                    <th>{{ __('end_date') }}</th>
                                    <th>{{ __('status') }}</th>
                                    <th>{{ __('actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($subscriptions ?? [] as $subscription)
                                <tr>
                                    <td>#{{ $subscription->id }}</td>
                                    <td>{{ $subscription->user->name ?? 'N/A' }}</td>
                                    <td>{{ $subscription->package->name ?? 'N/A' }}</td>
                                    <td>{{ $subscription->start_date }}</td>
                                    <td>{{ $subscription->end_date }}</td>
                                    <td>
                                        @if($subscription->status == 'active')
                                            <span class="badge bg-success">{{ __('active') }}</span>
                                        @elseif($subscription->status == 'expired')
                                            <span class="badge bg-danger">{{ __('expired') }}</span>
                                        @else
                                            <span class="badge bg-secondary">{{ __('cancelled') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editSubscriptionModal{{ $subscription->id }}">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="deleteSubscription({{ $subscription->id }})">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">{{ __('no_data') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    {{ $subscriptions->links() ?? '' }}
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.subscriptions.modals.add')
@include('admin.subscriptions.modals.edit')
@endsection
