<!-- Edit Shortener Modals -->
@foreach($shorteners ?? [] as $shortener)
<div class="modal fade" id="editShortenerModal{{ $shortener->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('edit_shortener') }}: {{ $shortener->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.shorteners.update', $shortener->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('name') }}</label>
                        <input type="text" name="name" class="form-control" value="{{ $shortener->name }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('api_provider') }}</label>
                        <select name="provider" class="form-control" required>
                            <option value="bitly" {{ $shortener->provider == 'bitly' ? 'selected' : '' }}>Bit.ly</option>
                            <option value="tinyurl" {{ $shortener->provider == 'tinyurl' ? 'selected' : '' }}>TinyURL</option>
                            <option value="isgd" {{ $shortener->provider == 'isgd' ? 'selected' : '' }}>is.gd</option>
                            <option value="custom" {{ $shortener->provider == 'custom' ? 'selected' : '' }}>{{ __('custom') }}</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('api_key') }}</label>
                        <input type="text" name="api_key" class="form-control" value="{{ $shortener->api_key }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('api_url') }}</label>
                        <input type="url" name="api_url" class="form-control" value="{{ $shortener->api_url }}">
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" name="status" class="form-check-input" value="1" {{ $shortener->status ? 'checked' : '' }}>
                        <label class="form-check-label">{{ __('active') }}</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
