<!-- Add Shortener Modal -->
<div class="modal fade" id="addShortenerModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('add_shortener') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.shorteners.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('name') }}</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('api_provider') }}</label>
                        <select name="provider" class="form-control" required>
                            <option value="bitly">Bit.ly</option>
                            <option value="tinyurl">TinyURL</option>
                            <option value="isgd">is.gd</option>
                            <option value="custom">{{ __('custom') }}</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('api_key') }}</label>
                        <input type="text" name="api_key" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('api_url') }}</label>
                        <input type="url" name="api_url" class="form-control" placeholder="{{ __('for_custom_only') }}">
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" name="status" class="form-check-input" value="1" checked>
                        <label class="form-check-label">{{ __('active') }}</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
