@extends('layouts.admin')

@section('title', __('admin_settings'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('admin_settings') }}</h5>
                </div>
                <div class="card-body">
                    <ul class="nav nav-tabs" id="settingsTabs">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#generalTab">{{ __('general') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#systemTab">{{ __('system') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#paymentTab">{{ __('payment') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#themeTab">{{ __('theme') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#cronTab">{{ __('cron') }}</a>
                        </li>
                    </ul>
                    
                    <div class="tab-content mt-4">
                        <!-- General Settings Tab -->
                        <div class="tab-pane fade show active" id="generalTab">
                            <form action="{{ route('admin.settings.general') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('site_name') }}</label>
                                        <input type="text" name="site_name" class="form-control" value="{{ $settings['site_name'] ?? '' }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('site_url') }}</label>
                                        <input type="url" name="site_url" class="form-control" value="{{ $settings['site_url'] ?? '' }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('contact_email') }}</label>
                                        <input type="email" name="contact_email" class="form-control" value="{{ $settings['contact_email'] ?? '' }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('default_language') }}</label>
                                        <select name="default_language" class="form-control">
                                            @foreach($languages ?? [] as $lang)
                                            <option value="{{ $lang->id }}" {{ ($settings['default_language'] ?? '') == $lang->id ? 'selected' : '' }}>{{ $lang->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('default_timezone') }}</label>
                                        <select name="default_timezone" class="form-control">
                                            @foreach(timezone_identifiers_list() as $tz)
                                            <option value="{{ $tz }}" {{ ($settings['default_timezone'] ?? 'UTC') == $tz ? 'selected' : '' }}>{{ $tz }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('currency') }}</label>
                                        <input type="text" name="currency" class="form-control" value="{{ $settings['currency'] ?? 'USD' }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('logo') }}</label>
                                        <input type="file" name="logo" class="form-control" accept="image/*">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('favicon') }}</label>
                                        <input type="file" name="favicon" class="form-control" accept="image/*">
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">{{ __('save_settings') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        
                        <!-- System Settings Tab -->
                        <div class="tab-pane fade" id="systemTab">
                            <form action="{{ route('admin.settings.system') }}" method="POST">
                                @csrf
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <div class="form-check">
                                            <input type="checkbox" name="registrations" class="form-check-input" value="1" {{ ($settings['registrations'] ?? 1) ? 'checked' : '' }}>
                                            <label class="form-check-label">{{ __('enable_registrations') }}</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <div class="form-check">
                                            <input type="checkbox" name="email_verification" class="form-check-input" value="1" {{ ($settings['email_verification'] ?? 0) ? 'checked' : '' }}>
                                            <label class="form-check-label">{{ __('require_email_verification') }}</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('free_model') }}</label>
                                        <select name="free_model" class="form-control">
                                            <option value="1" {{ ($settings['free_model'] ?? 1) == 1 ? 'selected' : '' }}>{{ __('freemium') }}</option>
                                            <option value="2" {{ ($settings['free_model'] ?? 1) == 2 ? 'selected' : '' }}>{{ __('paid_only') }}</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('default_package') }}</label>
                                        <select name="default_package" class="form-control">
                                            @foreach($packages ?? [] as $package)
                                            <option value="{{ $package->id }}" {{ ($settings['default_package'] ?? '') == $package->id ? 'selected' : '' }}>{{ $package->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">{{ __('save_settings') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        
                        <!-- Payment Settings Tab -->
                        <div class="tab-pane fade" id="paymentTab">
                            <form action="{{ route('admin.settings.payment') }}" method="POST">
                                @csrf
                                <h6 class="mb-3">{{ __('paypal_settings') }}</h6>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <div class="form-check">
                                            <input type="checkbox" name="paypal_enabled" class="form-check-input" value="1" {{ ($settings['paypal_enabled'] ?? 0) ? 'checked' : '' }}>
                                            <label class="form-check-label">{{ __('enable_paypal') }}</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('paypal_mode') }}</label>
                                        <select name="paypal_mode" class="form-control">
                                            <option value="sandbox">Sandbox</option>
                                            <option value="live">Live</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('paypal_client_id') }}</label>
                                        <input type="text" name="paypal_client_id" class="form-control" value="{{ $settings['paypal_client_id'] ?? '' }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('paypal_secret') }}</label>
                                        <input type="password" name="paypal_secret" class="form-control">
                                    </div>
                                </div>
                                
                                <hr>
                                
                                <h6 class="mb-3">{{ __('stripe_settings') }}</h6>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <div class="form-check">
                                            <input type="checkbox" name="stripe_enabled" class="form-check-input" value="1" {{ ($settings['stripe_enabled'] ?? 0) ? 'checked' : '' }}>
                                            <label class="form-check-label">{{ __('enable_stripe') }}</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6"></div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('stripe_public_key') }}</label>
                                        <input type="text" name="stripe_public_key" class="form-control" value="{{ $settings['stripe_public_key'] ?? '' }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('stripe_secret_key') }}</label>
                                        <input type="password" name="stripe_secret_key" class="form-control">
                                    </div>
                                </div>
                                
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">{{ __('save_settings') }}</button>
                                </div>
                            </form>
                        </div>
                        
                        <!-- Theme Settings Tab -->
                        <div class="tab-pane fade" id="themeTab">
                            <form action="{{ route('admin.settings.theme') }}" method="POST">
                                @csrf
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('primary_color') }}</label>
                                        <input type="color" name="primary_color" class="form-control form-control-color" value="{{ $settings['primary_color'] ?? '#007bff' }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('secondary_color') }}</label>
                                        <input type="color" name="secondary_color" class="form-control form-control-color" value="{{ $settings['secondary_color'] ?? '#6c757d' }}">
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">{{ __('save_settings') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        
                        <!-- Cron Settings Tab -->
                        <div class="tab-pane fade" id="cronTab">
                            <h6 class="mb-3">{{ __('cron_setup') }}</h6>
                            <div class="alert alert-info">
                                <p>{{ __('cron_setup_instructions') }}</p>
                                <div class="bg-dark text-light p-3 rounded">
                                    <code>* * * * * cd {{ base_path() }} && php artisan schedule:run >> /dev/null 2>&1</code>
                                </div>
                            </div>
                            <h6 class="mt-4 mb-3">{{ __('cron_tasks') }}</h6>
                            <ul>
                                <li>{{ __('process_scheduled_messages') }}</li>
                                <li>{{ __('check_expired_subscriptions') }}</li>
                                <li>{{ __('send_expiry_notifications') }}</li>
                                <li>{{ __('cleanup_old_logs') }}</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
