@extends('layouts.admin')

@section('title', __('dashboard_roles_title'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ __('dashboard_roles_title') }}</h5>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addRoleModal">
                        <i class="bi bi-plus-lg"></i> {{ __('add_role') }}
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="rolesTable">
                            <thead>
                                <tr>
                                    <th>{{ __('id') }}</th>
                                    <th>{{ __('name') }}</th>
                                    <th>{{ __('permissions') }}</th>
                                    <th>{{ __('users_count') }}</th>
                                    <th>{{ __('actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($roles ?? [] as $role)
                                <tr>
                                    <td>{{ $role->id }}</td>
                                    <td>{{ $role->name }}</td>
                                    <td>
                                        @php $perms = explode(',', $role->permissions ?? ''); @endphp
                                        {{ count($perms) }} {{ __('permissions') }}
                                    </td>
                                    <td>{{ $role->users_count ?? 0 }}</td>
                                    <td>
                                        @if($role->id > 1)
                                        <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editRoleModal{{ $role->id }}">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="deleteRole({{ $role->id }})">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                        @else
                                        <span class="badge bg-secondary">{{ __('default_role') }}</span>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center">{{ __('no_data') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.roles.modals.add')
@include('admin.roles.modals.edit')
@endsection
