<!-- Edit Plugin Modals -->
@foreach($plugins ?? [] as $plugin)
<div class="modal fade" id="editPluginModal{{ $plugin->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('edit_plugin') }}: {{ $plugin->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.plugins.update', $plugin->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('name') }}</label>
                        <input type="text" class="form-control" value="{{ $plugin->name }}" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('version') }}</label>
                        <input type="text" class="form-control" value="{{ $plugin->version }}" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('description') }}</label>
                        <textarea class="form-control" rows="3" readonly>{{ $plugin->description }}</textarea>
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" name="status" class="form-check-input" value="1" {{ $plugin->status ? 'checked' : '' }}>
                        <label class="form-check-label">{{ __('active') }}</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
