@extends('layouts.admin')

@section('title', __('dashboard_admin_pluginstitle'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ __('dashboard_admin_pluginstitle') }}</h5>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPluginModal">
                        <i class="bi bi-plus-lg"></i> {{ __('add_plugin') }}
                    </button>
                </div>
                <div class="card-body">
                    <div class="row">
                        @forelse($plugins ?? [] as $plugin)
                        <div class="col-md-4 mb-4">
                            <div class="card h-100">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="plugin-icon me-3">
                                            <i class="bi bi-puzzle fs-2 text-primary"></i>
                                        </div>
                                        <div>
                                            <h5 class="card-title mb-0">{{ $plugin->name }}</h5>
                                            <small class="text-muted">v{{ $plugin->version }}</small>
                                        </div>
                                    </div>
                                    <p class="card-text">{{ $plugin->description }}</p>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="badge {{ $plugin->status ? 'bg-success' : 'bg-secondary' }}">
                                            {{ $plugin->status ? __('active') : __('inactive') }}
                                        </span>
                                        <div>
                                            <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editPluginModal{{ $plugin->id }}">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-sm btn-danger" onclick="deletePlugin({{ $plugin->id }})">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="col-12">
                            <div class="alert alert-info text-center">
                                {{ __('no_plugins') }}
                            </div>
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.plugins.modals.add')
@include('admin.plugins.modals.edit')
@endsection
