<!-- Edit Page Modals -->
@foreach($pages ?? [] as $page)
<div class="modal fade" id="editPageModal{{ $page->id }}" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('edit_page') }}: {{ $page->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.pages.update', $page->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('name') }}</label>
                            <input type="text" name="name" class="form-control" value="{{ $page->name }}" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('slug') }}</label>
                            <input type="text" name="slug" class="form-control" value="{{ $page->slug }}" required>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('content') }}</label>
                            <textarea name="content" class="form-control" rows="10">{{ $page->content }}</textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('roles') }}</label>
                            @php $pageRoles = explode(',', $page->roles ?? ''); @endphp
                            <select name="roles[]" class="form-control" multiple>
                                <option value="1" {{ in_array('1', $pageRoles) ? 'selected' : '' }}>{{ __('all_users') }}</option>
                                @foreach($roles ?? [] as $role)
                                <option value="{{ $role->id }}" {{ in_array($role->id, $pageRoles) ? 'selected' : '' }}>{{ $role->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check mt-4">
                                <input type="checkbox" name="status" class="form-check-input" value="1" {{ $page->status ? 'checked' : '' }}>
                                <label class="form-check-label">{{ __('active') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
