<!-- Add Package Modal -->
<div class="modal fade" id="addPackageModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('add_package') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.packages.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('name') }}</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('price') }}</label>
                            <input type="number" name="price" class="form-control" step="0.01" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('duration') }} ({{ __('days') }})</label>
                            <input type="number" name="duration" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('send_limit') }}</label>
                            <input type="number" name="send_limit" class="form-control" value="0">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('receive_limit') }}</label>
                            <input type="number" name="receive_limit" class="form-control" value="0">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('device_limit') }}</label>
                            <input type="number" name="device_limit" class="form-control" value="0">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('contact_limit') }}</label>
                            <input type="number" name="contact_limit" class="form-control" value="0">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('wa_account_limit') }}</label>
                            <input type="number" name="wa_account_limit" class="form-control" value="0">
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('services') }}</label>
                            <select name="services[]" class="form-control" multiple>
                                <option value="sms">SMS</option>
                                <option value="whatsapp">WhatsApp</option>
                                <option value="api">API</option>
                                <option value="webhooks">Webhooks</option>
                                <option value="actions">Actions</option>
                                <option value="templates">Templates</option>
                                <option value="flows">Flows</option>
                                <option value="ai">AI</option>
                            </select>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('description') }}</label>
                            <textarea name="description" class="form-control" rows="3"></textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check">
                                <input type="checkbox" name="status" class="form-check-input" value="1" checked>
                                <label class="form-check-label">{{ __('active') }}</label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check">
                                <input type="checkbox" name="hidden" class="form-check-input" value="1">
                                <label class="form-check-label">{{ __('hidden') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
