<!-- Translate Language Modals -->
@foreach($languages ?? [] as $language)
<div class="modal fade" id="translateModal{{ $language->id }}" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('translate') }}: {{ $language->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.languages.translate', $language->id) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <input type="text" class="form-control" placeholder="{{ __('search_translations') }}" id="searchTranslations{{ $language->id }}">
                    </div>
                    <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th width="30%">{{ __('key') }}</th>
                                    <th width="35%">{{ __('default_value') }}</th>
                                    <th width="35%">{{ __('translation') }}</th>
                                </tr>
                            </thead>
                            <tbody id="translationsBody{{ $language->id }}">
                                @foreach($translations ?? [] as $key => $value)
                                <tr>
                                    <td><code>{{ $key }}</code></td>
                                    <td>{{ $value }}</td>
                                    <td>
                                        <input type="text" name="translations[{{ $key }}]" class="form-control form-control-sm" value="{{ $language->translations[$key] ?? '' }}">
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('save_translations') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
