<!-- Add Language Modal -->
<div class="modal fade" id="addLanguageModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('add_language') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.languages.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('name') }}</label>
                        <input type="text" name="name" class="form-control" placeholder="English" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('code') }}</label>
                        <input type="text" name="code" class="form-control" placeholder="en" maxlength="5" required>
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" name="rtl" class="form-check-input" value="1">
                        <label class="form-check-label">{{ __('rtl_language') }}</label>
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" name="is_default" class="form-check-input" value="1">
                        <label class="form-check-label">{{ __('set_as_default') }}</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
