@extends('layouts.admin')

@section('title', __('and_admin_gate_3'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ __('and_admin_gate_3') }}</h5>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addGatewayModal">
                        <i class="bi bi-plus-lg"></i> {{ __('add_gateway') }}
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="gatewaysTable">
                            <thead>
                                <tr>
                                    <th>{{ __('id') }}</th>
                                    <th>{{ __('name') }}</th>
                                    <th>{{ __('type') }}</th>
                                    <th>{{ __('status') }}</th>
                                    <th>{{ __('actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($gateways ?? [] as $gateway)
                                <tr>
                                    <td>{{ $gateway->id }}</td>
                                    <td>{{ $gateway->name }}</td>
                                    <td>{{ ucfirst($gateway->type) }}</td>
                                    <td>
                                        @if($gateway->status)
                                            <span class="badge bg-success">{{ __('active') }}</span>
                                        @else
                                            <span class="badge bg-danger">{{ __('inactive') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#ratesModal{{ $gateway->id }}">
                                            <i class="bi bi-currency-dollar"></i> {{ __('rates') }}
                                        </button>
                                        <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editGatewayModal{{ $gateway->id }}">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="deleteGateway({{ $gateway->id }})">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center">{{ __('no_data') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.gateways.modals.add')
@include('admin.gateways.modals.edit')
@include('admin.gateways.modals.rates')
@endsection
