@extends('layouts.admin')

@section('title', __('Admin Dashboard'))
@section('page-title', __('Admin Dashboard'))

@section('content')
<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-2">
        <div class="admin-stat-card">
            <div class="value">{{ number_format($stats['total_users']) }}</div>
            <div class="text-muted">{{ __('Total Users') }}</div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="admin-stat-card">
            <div class="value">{{ number_format($stats['active_users']) }}</div>
            <div class="text-muted">{{ __('Active Users') }}</div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="admin-stat-card">
            <div class="value">{{ number_format($stats['total_wa_accounts']) }}</div>
            <div class="text-muted">{{ __('WA Accounts') }}</div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="admin-stat-card">
            <div class="value">{{ number_format($stats['messages_today']) }}</div>
            <div class="text-muted">{{ __('Sent Today') }}</div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="admin-stat-card">
            <div class="value">{{ number_format($stats['received_today']) }}</div>
            <div class="text-muted">{{ __('Received Today') }}</div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="admin-stat-card">
            <div class="value">${{ number_format($stats['revenue_this_month'], 2) }}</div>
            <div class="text-muted">{{ __('Revenue') }}</div>
        </div>
    </div>
</div>

<div class="row g-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">{{ __('Activity Overview') }}</div>
            <div class="card-body">
                <canvas id="adminChart" height="300"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">{{ __('Recent Users') }}</div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    @foreach($recentUsers as $user)
                    <li class="list-group-item d-flex justify-content-between">
                        <div>
                            <strong>{{ $user->name }}</strong>
                            <br><small class="text-muted">{{ $user->email }}</small>
                        </div>
                        <small class="text-muted">{{ $user->create_date }}</small>
                    </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
const ctx = document.getElementById('adminChart').getContext('2d');
new Chart(ctx, {
    type: 'bar',
    data: {
        labels: @json($chartData['labels']),
        datasets: [{
            label: '{{ __('New Users') }}',
            data: @json($chartData['users']),
            backgroundColor: '#3b82f6'
        }, {
            label: '{{ __('Messages') }}',
            data: @json($chartData['messages']),
            backgroundColor: '#10b981'
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});
</script>
@endpush
